/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.entity.enums;

import cn.lili.common.utils.StringUtils;
import java.util.Arrays;

public enum AuthUserGender {
    MALE("1", "\u7537"),
    FEMALE("0", "\u5973"),
    UNKNOWN("-1", "\u672a\u77e5");

    private final String code;
    private final String desc;

    public static AuthUserGender getRealGender(String originalGender) {
        if (null == originalGender || UNKNOWN.getCode().equals(originalGender)) {
            return UNKNOWN;
        }
        String[] males = new String[]{"m", "\u7537", "1", "male"};
        if (Arrays.asList(males).contains(originalGender.toLowerCase())) {
            return MALE;
        }
        return FEMALE;
    }

    public static AuthUserGender getWechatRealGender(String originalGender) {
        String noGender = "0";
        if (StringUtils.isEmpty((CharSequence)originalGender) || noGender.equals(originalGender)) {
            return UNKNOWN;
        }
        return AuthUserGender.getRealGender(originalGender);
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private AuthUserGender(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}

