/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.request;

import cn.hutool.core.convert.Convert;
import cn.lili.cache.Cache;
import cn.lili.common.utils.StringUtils;
import cn.lili.common.utils.UrlBuilder;
import cn.lili.modules.connect.config.AuthConfig;
import cn.lili.modules.connect.config.ConnectAuthEnum;
import cn.lili.modules.connect.entity.dto.AuthCallback;
import cn.lili.modules.connect.entity.dto.AuthResponse;
import cn.lili.modules.connect.entity.dto.AuthToken;
import cn.lili.modules.connect.entity.dto.ConnectAuthUser;
import cn.lili.modules.connect.entity.enums.AuthResponseStatus;
import cn.lili.modules.connect.entity.enums.AuthUserGender;
import cn.lili.modules.connect.exception.AuthException;
import cn.lili.modules.connect.request.BaseAuthRequest;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.request.AlipayUserInfoShareRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.alipay.api.response.AlipayUserInfoShareResponse;

public class BaseAuthAlipayRequest
extends BaseAuthRequest {
    private final AlipayClient alipayClient;

    public BaseAuthAlipayRequest(AuthConfig config, Cache cache) {
        super(config, ConnectAuthEnum.ALIPAY, cache);
        this.alipayClient = new DefaultAlipayClient(ConnectAuthEnum.ALIPAY.accessToken(), config.getClientId(), config.getClientSecret(), "json", "UTF-8", config.getAlipayPublicKey(), "RSA2");
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("authorization_code");
        request.setCode(authCallback.getAuthCode());
        AlipaySystemOauthTokenResponse response = null;
        try {
            response = (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
        if (!response.isSuccess()) {
            throw new AuthException(response.getSubMsg());
        }
        return AuthToken.builder().accessToken(response.getAccessToken()).uid(response.getUserId()).expireIn(Convert.toInt((Object)response.getExpiresIn())).refreshToken(response.getRefreshToken()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("refresh_token");
        request.setRefreshToken(authToken.getRefreshToken());
        AlipaySystemOauthTokenResponse response = null;
        try {
            response = (AlipaySystemOauthTokenResponse)this.alipayClient.execute((AlipayRequest)request);
        }
        catch (Exception e) {
            throw new AuthException(e);
        }
        if (!response.isSuccess()) {
            throw new AuthException(response.getSubMsg());
        }
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(AuthToken.builder().accessToken(response.getAccessToken()).uid(response.getUserId()).expireIn(Convert.toInt((Object)response.getExpiresIn())).refreshToken(response.getRefreshToken()).build()).build();
    }

    @Override
    protected ConnectAuthUser getUserInfo(AuthToken authToken) {
        String accessToken = authToken.getAccessToken();
        AlipayUserInfoShareRequest request = new AlipayUserInfoShareRequest();
        AlipayUserInfoShareResponse response = null;
        try {
            response = (AlipayUserInfoShareResponse)this.alipayClient.execute((AlipayRequest)request, accessToken);
        }
        catch (AlipayApiException e) {
            throw new AuthException(e.getErrMsg(), e);
        }
        if (!response.isSuccess()) {
            throw new AuthException(response.getSubMsg());
        }
        String province = response.getProvince();
        String city = response.getCity();
        String location = String.format("%s %s", StringUtils.isEmpty((CharSequence)province) ? "" : province, StringUtils.isEmpty((CharSequence)city) ? "" : city);
        return ConnectAuthUser.builder().rawUserInfo(JSONObject.parseObject((String)JSONObject.toJSONString((Object)response))).uuid(response.getUserId()).username(StringUtils.isEmpty((CharSequence)response.getUserName()) ? response.getNickName() : response.getUserName()).nickname(response.getNickName()).avatar(response.getAvatar()).location(location).gender(AuthUserGender.getRealGender(response.getGender())).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl((String)this.source.authorize()).queryParam("app_id", (Object)this.config.getClientId()).queryParam("scope", (Object)"auth_user").queryParam("redirect_uri", (Object)this.config.getRedirectUri()).queryParam("state", (Object)this.getRealState(state)).build();
    }
}

