/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.request;

import cn.hutool.core.convert.Convert;
import cn.lili.cache.Cache;
import cn.lili.common.utils.HttpUtils;
import cn.lili.common.utils.StringUtils;
import cn.lili.common.utils.UrlBuilder;
import cn.lili.modules.connect.config.AuthConfig;
import cn.lili.modules.connect.config.ConnectAuthEnum;
import cn.lili.modules.connect.entity.dto.AuthCallback;
import cn.lili.modules.connect.entity.dto.AuthResponse;
import cn.lili.modules.connect.entity.dto.AuthToken;
import cn.lili.modules.connect.entity.dto.ConnectAuthUser;
import cn.lili.modules.connect.entity.enums.AuthResponseStatus;
import cn.lili.modules.connect.entity.enums.AuthUserGender;
import cn.lili.modules.connect.exception.AuthException;
import cn.lili.modules.connect.request.BaseAuthRequest;
import cn.lili.modules.connect.util.GlobalAuthUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;

public class BaseAuthQQRequest
extends BaseAuthRequest {
    public BaseAuthQQRequest(AuthConfig config, Cache cache) {
        super(config, ConnectAuthEnum.QQ, cache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doGetAuthorizationCode(authCallback.getCode());
        return this.getAuthToken(response);
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.refreshTokenUrl(authToken.getRefreshToken()));
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    @Override
    protected ConnectAuthUser getUserInfo(AuthToken authToken) {
        String openId = this.getOpenId(authToken);
        String response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.getIntValue("ret") != 0) {
            throw new AuthException(object.getString("msg"));
        }
        String avatar = object.getString("figureurl_qq_2");
        if (StringUtils.isEmpty((CharSequence)avatar)) {
            avatar = object.getString("figureurl_qq_1");
        }
        String location = String.format("%s-%s", object.getString("province"), object.getString("city"));
        return ConnectAuthUser.builder().rawUserInfo(object).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(avatar).location(location).uuid(openId).gender(AuthUserGender.getRealGender(object.getString("gender"))).token(authToken).source(this.source.toString()).build();
    }

    private String getOpenId(AuthToken authToken) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(UrlBuilder.fromBaseUrl((String)"https://graph.qq.com/oauth2.0/me").queryParam("access_token", (Object)authToken.getAccessToken()).queryParam("unionid", (Object)(this.config.isUnionId() ? 1 : 0)).build());
        String removePrefix = response.replace("callback(", "");
        String removeSuffix = removePrefix.replace(");", "");
        String openId = removeSuffix.trim();
        JSONObject object = JSONObject.parseObject((String)openId);
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.get((Object)"error") + ":" + object.get((Object)"error_description"));
        }
        authToken.setOpenId(object.getString("openid"));
        if (object.containsKey((Object)"unionid")) {
            authToken.setUnionId(object.getString("unionid"));
        }
        return StringUtils.isEmpty((CharSequence)authToken.getUnionId()) ? authToken.getOpenId() : authToken.getUnionId();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.userInfo()).queryParam("access_token", (Object)authToken.getAccessToken()).queryParam("oauth_consumer_key", (Object)this.config.getClientId()).queryParam("openid", (Object)authToken.getOpenId()).build();
    }

    private AuthToken getAuthToken(String response) {
        Map<String, String> accessTokenObject = GlobalAuthUtils.parseStringToMap(response);
        if (!accessTokenObject.containsKey("access_token") || accessTokenObject.containsKey("code")) {
            throw new AuthException(accessTokenObject.get("msg"));
        }
        return AuthToken.builder().accessToken(accessTokenObject.get("access_token")).expireIn(Convert.toInt((Object)accessTokenObject.getOrDefault("expires_in", "0"))).refreshToken(accessTokenObject.get("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl((String)super.authorize(state)).queryParam("scope", (Object)"get_user_info").build();
    }
}

