/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.request;

import cn.lili.cache.Cache;
import cn.lili.common.utils.HttpUtils;
import cn.lili.common.utils.UrlBuilder;
import cn.lili.modules.connect.config.AuthConfig;
import cn.lili.modules.connect.config.ConnectAuthEnum;
import cn.lili.modules.connect.entity.dto.AuthCallback;
import cn.lili.modules.connect.entity.dto.AuthResponse;
import cn.lili.modules.connect.entity.dto.AuthToken;
import cn.lili.modules.connect.entity.dto.ConnectAuthUser;
import cn.lili.modules.connect.entity.enums.AuthResponseStatus;
import cn.lili.modules.connect.entity.enums.AuthUserGender;
import cn.lili.modules.connect.exception.AuthException;
import cn.lili.modules.connect.request.BaseAuthRequest;
import cn.lili.modules.connect.util.GlobalAuthUtils;
import com.alibaba.fastjson.JSONObject;

public class BaseAuthWeChatRequest
extends BaseAuthRequest {
    public BaseAuthWeChatRequest(AuthConfig config, Cache cache) {
        super(config, ConnectAuthEnum.WECHAT, cache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        return this.getToken(this.accessTokenUrl(authCallback.getCode()));
    }

    @Override
    protected ConnectAuthUser getUserInfo(AuthToken authToken) {
        String openId = authToken.getOpenId();
        String response = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        String location = String.format("%s-%s-%s", object.getString("country"), object.getString("province"), object.getString("city"));
        if (object.containsKey((Object)"unionid")) {
            authToken.setUnionId(object.getString("unionid"));
        }
        return ConnectAuthUser.builder().rawUserInfo(object).username(object.getString("nickname")).nickname(object.getString("nickname")).avatar(object.getString("headimgurl")).location(location).uuid(openId).gender(AuthUserGender.getWechatRealGender(object.getString("sex"))).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken oldToken) {
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getToken(this.refreshTokenUrl(oldToken.getRefreshToken()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"errcode")) {
            throw new AuthException(object.getIntValue("errcode"), object.getString("errmsg"));
        }
    }

    private AuthToken getToken(String accessTokenUrl) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(accessTokenUrl);
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).openId(accessTokenObject.getString("openid")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl((String)this.source.authorize()).queryParam("appid", (Object)this.config.getClientId()).queryParam("redirect_uri", (Object)GlobalAuthUtils.urlEncode(this.config.getRedirectUri())).queryParam("response_type", (Object)"code").queryParam("scope", (Object)"snsapi_userinfo").queryParam("state", (Object)this.getRealState(state).concat("#wechat_redirect")).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl((String)this.source.accessToken()).queryParam("code", (Object)code).queryParam("appid", (Object)this.config.getClientId()).queryParam("secret", (Object)this.config.getClientSecret()).queryParam("grant_type", (Object)"authorization_code").build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.userInfo()).queryParam("access_token", (Object)authToken.getAccessToken()).queryParam("openid", (Object)authToken.getOpenId()).queryParam("lang", (Object)"zh_CN").build();
    }

    @Override
    protected String refreshTokenUrl(String refreshToken) {
        return UrlBuilder.fromBaseUrl((String)this.source.refresh()).queryParam("appid", (Object)this.config.getClientId()).queryParam("refresh_token", (Object)refreshToken).queryParam("grant_type", (Object)"refresh_token").build();
    }
}

