/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.connect.util;

import cn.lili.cache.Cache;
import cn.lili.modules.connect.config.AuthConfig;
import cn.lili.modules.connect.config.ConnectAuth;
import cn.lili.modules.connect.config.ConnectAuthEnum;
import cn.lili.modules.connect.entity.dto.AuthCallback;
import cn.lili.modules.connect.entity.enums.AuthResponseStatus;
import cn.lili.modules.connect.exception.AuthException;
import cn.lili.modules.connect.util.GlobalAuthUtils;
import org.apache.commons.lang3.StringUtils;

public class AuthChecker {
    public static boolean isSupportedAuth(AuthConfig config, ConnectAuth connectAuth) {
        boolean isSupported;
        boolean bl = isSupported = StringUtils.isNotEmpty((CharSequence)config.getClientId()) && StringUtils.isNotEmpty((CharSequence)config.getClientSecret()) && StringUtils.isNotEmpty((CharSequence)config.getRedirectUri());
        if (isSupported && ConnectAuthEnum.ALIPAY == connectAuth) {
            isSupported = StringUtils.isNotEmpty((CharSequence)config.getAlipayPublicKey());
        }
        return isSupported;
    }

    public static void checkConfig(AuthConfig config, ConnectAuth connectAuth) {
        String redirectUri = config.getRedirectUri();
        if (!GlobalAuthUtils.isHttpProtocol(redirectUri) && !GlobalAuthUtils.isHttpsProtocol(redirectUri)) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_REDIRECT_URI, connectAuth);
        }
        if (ConnectAuthEnum.ALIPAY == connectAuth && GlobalAuthUtils.isLocalHost(redirectUri)) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_REDIRECT_URI, connectAuth);
        }
    }

    public static void checkCode(ConnectAuth connectAuth, AuthCallback callback) {
        String code = callback.getCode();
        if (connectAuth == ConnectAuthEnum.ALIPAY) {
            code = callback.getAuthCode();
        }
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_CODE, connectAuth);
        }
    }

    public static void checkState(String state, ConnectAuth connectAuth, Cache cache) {
        if (StringUtils.isEmpty((CharSequence)state) || !cache.hasKey((Object)state)) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_STATUS, connectAuth);
        }
    }
}

