/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.file.plugin;

import cn.hutool.json.JSONUtil;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.file.entity.enums.OssEnum;
import cn.lili.modules.file.plugin.FilePlugin;
import cn.lili.modules.file.plugin.impl.AliFilePlugin;
import cn.lili.modules.file.plugin.impl.HuaweiFilePlugin;
import cn.lili.modules.file.plugin.impl.MinioFilePlugin;
import cn.lili.modules.file.plugin.impl.TencentFilePlugin;
import cn.lili.modules.system.client.SettingClient;
import cn.lili.modules.system.entity.dos.Setting;
import cn.lili.modules.system.entity.dto.OssSetting;
import cn.lili.modules.system.entity.enums.SettingEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FilePluginFactory {
    @Autowired
    private SettingClient settingClient;

    public FilePlugin filePlugin() {
        OssSetting ossSetting = null;
        try {
            Setting setting = this.settingClient.get(SettingEnum.OSS_SETTING.name());
            ossSetting = (OssSetting)JSONUtil.toBean((String)setting.getSettingValue(), OssSetting.class);
            switch (OssEnum.valueOf(ossSetting.getType())) {
                case MINIO: {
                    return new MinioFilePlugin(ossSetting);
                }
                case ALI_OSS: {
                    return new AliFilePlugin(ossSetting);
                }
                case HUAWEI_OBS: {
                    return new HuaweiFilePlugin(ossSetting);
                }
                case TENCENT_COS: {
                    return new TencentFilePlugin(ossSetting);
                }
            }
            throw new ServiceException();
        }
        catch (Exception e) {
            throw new ServiceException();
        }
    }
}

