/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.goods.client;

import cn.lili.modules.goods.entity.dos.Goods;
import cn.lili.modules.goods.entity.dos.GoodsSku;
import cn.lili.modules.goods.entity.dos.Wholesale;
import cn.lili.modules.goods.entity.dto.GoodsSearchParams;
import cn.lili.modules.goods.entity.vos.GoodsVO;
import cn.lili.modules.goods.fallback.GoodsFallback;
import cn.lili.modules.store.entity.dos.Store;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="goods-service", contextId="goods", fallback=GoodsFallback.class)
public interface GoodsClient {
    @GetMapping(value={"/feign/goods/vo/{goodsId}"})
    public GoodsVO getGoodsVO(@PathVariable String var1);

    @GetMapping(value={"/feign/goods/sku/{skuId}/cache"})
    public GoodsSku getGoodsSkuByIdFromCache(@PathVariable String var1);

    @PostMapping(value={"/feign/goods/sku/list/cache"})
    public List<GoodsSku> getGoodsSkuByIdFromCache(@RequestBody List<String> var1);

    @GetMapping(value={"/feign/goods/sku/promotion/{skuId}/cache"})
    public GoodsSku getCanPromotionGoodsSkuByIdFromCache(@PathVariable String var1);

    @PutMapping(value={"/feign/goods/update/store"})
    public void updateStoreDetail(@RequestBody Store var1);

    @PutMapping(value={"/feign/goods/under/store/{id}"})
    public void underStoreGoods(@PathVariable String var1);

    @PutMapping(value={"/feign/goods/del/store/{id}"})
    public void delStoreGoods(@PathVariable String var1);

    @GetMapping(value={"/feign/goods/{storeId}/count"})
    public Long count(@PathVariable String var1);

    @GetMapping(value={"/feign/goods/sku/{skuId}/stock"})
    public Integer getStock(@PathVariable String var1);

    @GetMapping(value={"/feign/goods/comment/{goodsId}/num"})
    public void addGoodsCommentNum(@RequestParam Integer var1, @PathVariable String var2);

    @GetMapping(value={"/feign/goods/goods/{goodsId}/getById"})
    public Goods getById(@PathVariable String var1);

    @PostMapping(value={"/feign/goods/queryListByParams"})
    public List<Goods> queryListByParams(@RequestBody GoodsSearchParams var1);

    @GetMapping(value={"/feign/goods/{goodsId}/getSkuIdsByGoodsId"})
    public List<String> getSkuIdsByGoodsId(@PathVariable String var1);

    @PostMapping(value={"/feign/goods/sku/list"})
    public List<GoodsSku> getGoodsSkuByList(@RequestBody GoodsSearchParams var1);

    @PutMapping(value={"/feign/goods/buy/{goodsId}/count"})
    public void updateGoodsBuyCount(@PathVariable String var1, @RequestParam int var2);

    @GetMapping(value={"/feign/goods/sku/{goodsId}"})
    public GoodsSku getGoodsSkuById(@PathVariable String var1);

    @PutMapping(value={"/feign/goods/goodsSku/updateGoodsSku"})
    public void updateGoodsSku(@RequestBody GoodsSku var1);

    @PostMapping(value={"/feign/goods/goods/getGoodsByParams"})
    public Goods getGoodsByParams(@RequestBody GoodsSearchParams var1);

    @PostMapping(value={"/feign/goods/wholesale/{goodsId}/match"})
    public Wholesale getMatchWholesale(@PathVariable String var1, @RequestParam Integer var2);

    @GetMapping(value={"/feign/goods/sku/countSkuNum/{storeId}"})
    public Long countSkuNum(@PathVariable String var1);

    @PostMapping(value={"/feign/goods/sku/getGoodsSkuByPage"})
    public Page<GoodsSku> getGoodsSkuByPage(@RequestBody GoodsSearchParams var1);

    @GetMapping(value={"/feign/goods/updateGoodsMarketEnable"})
    public void updateGoodsMarketEnable(@RequestParam String var1, @RequestParam String var2, @RequestParam String var3);

    @GetMapping(value={"/feign/goods/categoryGoodsName"})
    public void categoryGoodsName(@RequestParam String var1);
}

