/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.goods.client;

import cn.lili.modules.goods.entity.dto.GoodsSkuDTO;
import cn.lili.modules.goods.fallback.GoodsIndexFallback;
import cn.lili.modules.search.entity.dos.EsGoodsIndex;
import cn.lili.modules.search.entity.dto.EsGoodsIndexDTO;
import cn.lili.modules.search.entity.dto.EsGoodsIndexUpdateDTO;
import cn.lili.modules.search.entity.dto.EsGoodsIndexUpdatePromotionsDTO;
import cn.lili.modules.search.entity.dto.EsGoodsSkuIdsSearchDTO;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="goods-service", contextId="goods-index", fallback=GoodsIndexFallback.class)
public interface GoodsIndexClient {
    @PostMapping(value={"/feign/goods/es"})
    public List<EsGoodsIndex> getEsGoodsBySkuIds(@RequestBody EsGoodsSkuIdsSearchDTO var1);

    @GetMapping(value={"/feign/goods/es/{id}"})
    public EsGoodsIndex getEsGoodsIndex(@PathVariable String var1);

    @GetMapping(value={"/feign/goods/es/promotions/clean"})
    public void cleanEsGoodsIndexInvalidPromotions();

    @PostMapping(value={"/feign/goods/es/reset"})
    public EsGoodsIndex getResetEsGoodsIndex(@RequestBody GoodsSkuDTO var1);

    @PutMapping(value={"/feign/goods/index/field"})
    public void updateIndexField(@RequestBody EsGoodsIndexUpdateDTO var1);

    @PutMapping(value={"/feign/goods/index/promotions/list"})
    public void updateEsGoodsIndexByList(@RequestBody EsGoodsIndexUpdatePromotionsDTO var1);

    @PutMapping(value={"/feign/goods/index/promotions"})
    public void updateEsGoodsIndexPromotions(@RequestBody EsGoodsIndexUpdatePromotionsDTO var1);

    @PostMapping(value={"/feign/goods/index/promotions/list/all"})
    public void updateEsGoodsIndexAllByList(@RequestBody EsGoodsIndexUpdatePromotionsDTO var1);

    @PostMapping(value={"/feign/goods/index"})
    public void addIndex(@RequestBody EsGoodsIndexDTO var1);

    @PostMapping(value={"/feign/goods/index/batch"})
    public void addIndex(@RequestBody List<EsGoodsIndexDTO> var1);

    @DeleteMapping(value={"/feign/goods/index"})
    public void deleteIndex(@RequestBody Map<String, Object> var1);

    @PutMapping(value={"/feign/goods/index"})
    public void updateIndex(@RequestBody EsGoodsIndexDTO var1);

    @PutMapping(value={"/feign/goods/updateBulkIndex"})
    public void updateBulkIndex(@RequestBody List<EsGoodsIndex> var1);

    @GetMapping(value={"/feign/goods/{id}/deleteIndexById"})
    public void deleteIndexById(@PathVariable String var1);

    @GetMapping(value={"/feign/goods/{id}/findById"})
    public EsGoodsIndex findById(@PathVariable String var1);

    @DeleteMapping(value={"/feign/goods/esGoods/deleteIndexByIds"})
    public void deleteIndexByIds(@RequestBody List<String> var1);

    @DeleteMapping(value={"/feign/goods/esGoods/deleteEsGoodsPromotionByPromotion/{promotionsKey}"})
    public void deleteEsGoodsPromotionByPromotionKey(@RequestBody List<String> var1, @PathVariable String var2);

    @DeleteMapping(value={"/feign/goods/esGoods/deleteEsGoodsPromotionByPromotionKey/{promotionsKey}"})
    public void deleteEsGoodsPromotionByPromotionKey(@PathVariable String var1);
}

