/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.entity.dos;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import cn.lili.common.enums.PromotionTypeEnum;
import cn.lili.common.security.sensitive.Sensitive;
import cn.lili.common.security.sensitive.enums.SensitiveStrategy;
import cn.lili.common.utils.BeanUtil;
import cn.lili.modules.goods.entity.enums.GoodsTypeEnum;
import cn.lili.modules.order.cart.entity.dto.MemberCouponDTO;
import cn.lili.modules.order.cart.entity.dto.TradeDTO;
import cn.lili.modules.order.cart.entity.enums.CartTypeEnum;
import cn.lili.modules.order.cart.entity.enums.DeliveryMethodEnum;
import cn.lili.modules.order.cart.entity.vo.CartVO;
import cn.lili.modules.order.order.entity.dto.PriceDetailDTO;
import cn.lili.modules.order.order.entity.enums.DeliverStatusEnum;
import cn.lili.modules.order.order.entity.enums.OrderPromotionTypeEnum;
import cn.lili.modules.order.order.entity.enums.OrderStatusEnum;
import cn.lili.modules.order.order.entity.enums.OrderTypeEnum;
import cn.lili.modules.order.order.entity.enums.PayStatusEnum;
import cn.lili.mybatis.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Optional;
import org.springframework.format.annotation.DateTimeFormat;

@TableName(value="li_order")
@ApiModel(value="\u8ba2\u5355")
public class Order
extends BaseEntity {
    private static final long serialVersionUID = 2233811628066468683L;
    @ApiModelProperty(value="\u8ba2\u5355\u7f16\u53f7")
    private String sn;
    @ApiModelProperty(value="\u4ea4\u6613\u7f16\u53f7 \u5173\u8054Trade")
    private String tradeSn;
    @ApiModelProperty(value="\u5e97\u94faID")
    private String storeId;
    @ApiModelProperty(value="\u5e97\u94fa\u540d\u79f0")
    private String storeName;
    @ApiModelProperty(value="\u4f1a\u5458ID")
    private String memberId;
    @ApiModelProperty(value="\u7528\u6237\u540d")
    @Sensitive(strategy=SensitiveStrategy.PHONE)
    private String memberName;
    @ApiModelProperty(value="\u8ba2\u5355\u72b6\u6001")
    private String orderStatus;
    @ApiModelProperty(value="\u4ed8\u6b3e\u72b6\u6001")
    private String payStatus;
    @ApiModelProperty(value="\u8d27\u8fd0\u72b6\u6001")
    private String deliverStatus;
    @ApiModelProperty(value="\u7b2c\u4e09\u65b9\u4ed8\u6b3e\u6d41\u6c34\u53f7")
    private String receivableNo;
    @ApiModelProperty(value="\u652f\u4ed8\u65b9\u5f0f")
    private String paymentMethod;
    @ApiModelProperty(value="\u652f\u4ed8\u65f6\u95f4")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date paymentTime;
    @ApiModelProperty(value="\u6536\u4ef6\u4eba\u59d3\u540d")
    private String consigneeName;
    @ApiModelProperty(value="\u6536\u4ef6\u4eba\u624b\u673a")
    private String consigneeMobile;
    @ApiModelProperty(value="\u914d\u9001\u65b9\u5f0f")
    private String deliveryMethod;
    @ApiModelProperty(value="\u5730\u5740\u540d\u79f0\uff0c '\uff0c'\u5206\u5272")
    private String consigneeAddressPath;
    @ApiModelProperty(value="\u5730\u5740id\uff0c'\uff0c'\u5206\u5272 ")
    private String consigneeAddressIdPath;
    @ApiModelProperty(value="\u8be6\u7ec6\u5730\u5740")
    private String consigneeDetail;
    @ApiModelProperty(value="\u603b\u4ef7\u683c")
    private Double flowPrice;
    @ApiModelProperty(value="\u5546\u54c1\u4ef7\u683c")
    private Double goodsPrice;
    @ApiModelProperty(value="\u8fd0\u8d39")
    private Double freightPrice;
    @ApiModelProperty(value="\u4f18\u60e0\u7684\u91d1\u989d")
    private Double discountPrice;
    @ApiModelProperty(value="\u4fee\u6539\u4ef7\u683c")
    private Double updatePrice;
    @ApiModelProperty(value="\u53d1\u8d27\u5355\u53f7")
    private String logisticsNo;
    @ApiModelProperty(value="\u7269\u6d41\u516c\u53f8CODE")
    private String logisticsCode;
    @ApiModelProperty(value="\u7269\u6d41\u516c\u53f8\u540d\u79f0")
    private String logisticsName;
    @ApiModelProperty(value="\u8ba2\u5355\u5546\u54c1\u603b\u91cd\u91cf")
    private Double weight;
    @ApiModelProperty(value="\u5546\u54c1\u6570\u91cf")
    private Integer goodsNum;
    @ApiModelProperty(value="\u4e70\u5bb6\u8ba2\u5355\u5907\u6ce8")
    private String remark;
    @ApiModelProperty(value="\u8ba2\u5355\u53d6\u6d88\u539f\u56e0")
    private String cancelReason;
    @ApiModelProperty(value="\u5b8c\u6210\u65f6\u95f4")
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date completeTime;
    @ApiModelProperty(value="\u9001\u8d27\u65f6\u95f4")
    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    private Date logisticsTime;
    @ApiModelProperty(value="\u652f\u4ed8\u65b9\u5f0f\u8fd4\u56de\u7684\u4ea4\u6613\u53f7")
    private String payOrderNo;
    @ApiModelProperty(value="\u8ba2\u5355\u6765\u6e90")
    private String clientType;
    @ApiModelProperty(value="\u662f\u5426\u9700\u8981\u53d1\u7968")
    private Boolean needReceipt;
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u5176\u4ed6\u8ba2\u5355\u4e0b\u7684\u8ba2\u5355\uff0c\u5982\u679c\u662f\u5219\u4e3a\u4f9d\u8d56\u8ba2\u5355\u7684sn\uff0c\u5426\u5219\u4e3a\u7a7a")
    private String parentOrderSn = "";
    @ApiModelProperty(value="\u662f\u5426\u4e3a\u67d0\u8ba2\u5355\u7c7b\u578b\u7684\u8ba2\u5355\uff0c\u5982\u679c\u662f\u5219\u4e3a\u8ba2\u5355\u7c7b\u578b\u7684id\uff0c\u5426\u5219\u4e3a\u7a7a")
    private String promotionId;
    @ApiModelProperty(value="\u8ba2\u5355\u7c7b\u578b")
    private String orderType;
    @ApiModelProperty(value="\u8ba2\u5355\u4fc3\u9500\u7c7b\u578b")
    private String orderPromotionType;
    @ApiModelProperty(value="\u4ef7\u683c\u4ef7\u683c\u8be6\u60c5")
    private String priceDetail;
    @ApiModelProperty(value="\u8ba2\u5355\u662f\u5426\u652f\u6301\u539f\u8def\u9000\u56de")
    private Boolean canReturn;
    @ApiModelProperty(value="\u63d0\u8d27\u7801")
    private String verificationCode;
    @ApiModelProperty(value="\u5206\u9500\u5458ID")
    private String distributionId;
    @ApiModelProperty(value="\u4f7f\u7528\u7684\u5e97\u94fa\u4f1a\u5458\u4f18\u60e0\u5238id(,\u533a\u5206)")
    private String useStoreMemberCouponIds;
    @ApiModelProperty(value="\u4f7f\u7528\u7684\u5e73\u53f0\u4f1a\u5458\u4f18\u60e0\u5238id")
    private String usePlatformMemberCouponId;
    @ApiModelProperty(value="qrCode  \u5b9e\u7269\u4e3a\u63d0\u8d27\u7801  \u865a\u62df\u8d27\u7269\u4e3a\u8d26\u53f7")
    private String qrCode;
    @ApiModelProperty(value="\u81ea\u63d0\u70b9\u5730\u5740")
    private String storeAddressPath;
    @ApiModelProperty(value="\u81ea\u63d0\u70b9\u7535\u8bdd")
    private String storeAddressMobile;
    @ApiModelProperty(value="\u81ea\u63d0\u70b9\u5730\u5740\u7ecf\u7eac\u5ea6")
    private String storeAddressCenter;
    @ApiModelProperty(value="\u4fc3\u9500\u8d60\u9001\u79ef\u5206")
    private Integer giftPoint;

    public Order(CartVO cartVO, TradeDTO tradeDTO) {
        String oldId = this.getId();
        BeanUtil.copyProperties((Object)tradeDTO, (Object)((Object)this));
        BeanUtil.copyProperties((Object)cartVO.getPriceDetailDTO(), (Object)((Object)this));
        BeanUtil.copyProperties((Object)cartVO, (Object)((Object)this));
        this.setTradeType(cartVO, tradeDTO);
        this.setId(oldId);
        this.setOrderStatus(OrderStatusEnum.UNPAID.name());
        this.setPayStatus(PayStatusEnum.UNPAID.name());
        this.setDeliverStatus(DeliverStatusEnum.UNDELIVERED.name());
        this.setTradeSn(tradeDTO.getSn());
        this.setRemark(cartVO.getRemark());
        this.setGiftPoint(cartVO.getGiftPoint());
        this.setFreightPrice(tradeDTO.getPriceDetailDTO().getFreightPrice());
        if (DeliveryMethodEnum.LOGISTICS.name().equals(cartVO.getDeliveryMethod())) {
            this.setConsigneeAddressIdPath(tradeDTO.getMemberAddress().getConsigneeAddressIdPath());
            this.setConsigneeAddressPath(tradeDTO.getMemberAddress().getConsigneeAddressPath());
            this.setConsigneeDetail(tradeDTO.getMemberAddress().getDetail());
            this.setConsigneeMobile(tradeDTO.getMemberAddress().getMobile());
            this.setConsigneeName(tradeDTO.getMemberAddress().getName());
        }
        if (DeliveryMethodEnum.SELF_PICK_UP.name().equals(cartVO.getDeliveryMethod())) {
            this.setStoreAddressPath(tradeDTO.getStoreAddress().getAddress());
            this.setStoreAddressMobile(tradeDTO.getStoreAddress().getMobile());
            this.setStoreAddressCenter(tradeDTO.getStoreAddress().getCenter());
        }
        if (tradeDTO.getPlatformCoupon() != null) {
            this.setUsePlatformMemberCouponId(tradeDTO.getPlatformCoupon().getMemberCoupon().getId());
        }
        if (tradeDTO.getStoreCoupons() != null && !tradeDTO.getStoreCoupons().isEmpty()) {
            StringBuilder storeCouponIds = new StringBuilder();
            for (MemberCouponDTO value : tradeDTO.getStoreCoupons().values()) {
                storeCouponIds.append(value.getMemberCoupon().getId()).append(",");
            }
            this.setUseStoreMemberCouponIds(storeCouponIds.toString());
        }
    }

    private void setTradeType(CartVO cartVO, TradeDTO tradeDTO) {
        if (tradeDTO.getCartTypeEnum().equals((Object)CartTypeEnum.CART) || tradeDTO.getCartTypeEnum().equals((Object)CartTypeEnum.BUY_NOW)) {
            this.setOrderType(OrderTypeEnum.NORMAL.name());
            this.setOrderPromotionType(OrderPromotionTypeEnum.NORMAL.name());
        } else if (tradeDTO.getCartTypeEnum().equals((Object)CartTypeEnum.VIRTUAL)) {
            this.setOrderType(OrderTypeEnum.VIRTUAL.name());
            this.setOrderPromotionType(OrderPromotionTypeEnum.NORMAL.name());
        } else {
            String goodsType = cartVO.getCheckedSkuList().get(0).getGoodsSku().getGoodsType();
            if (CharSequenceUtil.isEmpty((CharSequence)goodsType) || goodsType.equals(GoodsTypeEnum.PHYSICAL_GOODS.name())) {
                this.setOrderType(OrderTypeEnum.NORMAL.name());
            } else {
                this.setOrderType(OrderTypeEnum.VIRTUAL.name());
            }
            this.setOrderPromotionType(tradeDTO.getCartTypeEnum().name());
            if (tradeDTO.getCartTypeEnum().name().equals(PromotionTypeEnum.PINTUAN.name()) && cartVO.getCheckedSkuList().get(0).getPromotionMap() != null && !cartVO.getCheckedSkuList().get(0).getPromotionMap().isEmpty()) {
                Optional<String> pintuanPromotions = cartVO.getCheckedSkuList().get(0).getPromotionMap().keySet().stream().filter(i -> i.contains(PromotionTypeEnum.PINTUAN.name())).findFirst();
                pintuanPromotions.ifPresent(s -> {
                    this.promotionId = s.split("-")[1];
                });
            }
        }
    }

    public PriceDetailDTO getPriceDetailDTO() {
        try {
            return (PriceDetailDTO)JSONUtil.toBean((String)this.priceDetail, PriceDetailDTO.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setPriceDetailDTO(PriceDetailDTO priceDetail) {
        this.priceDetail = JSONUtil.toJsonStr((Object)priceDetail);
    }

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Order)) {
            return false;
        }
        Order other = (Order)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Double this$flowPrice = this.getFlowPrice();
        Double other$flowPrice = other.getFlowPrice();
        if (this$flowPrice == null ? other$flowPrice != null : !((Object)this$flowPrice).equals(other$flowPrice)) {
            return false;
        }
        Double this$goodsPrice = this.getGoodsPrice();
        Double other$goodsPrice = other.getGoodsPrice();
        if (this$goodsPrice == null ? other$goodsPrice != null : !((Object)this$goodsPrice).equals(other$goodsPrice)) {
            return false;
        }
        Double this$freightPrice = this.getFreightPrice();
        Double other$freightPrice = other.getFreightPrice();
        if (this$freightPrice == null ? other$freightPrice != null : !((Object)this$freightPrice).equals(other$freightPrice)) {
            return false;
        }
        Double this$discountPrice = this.getDiscountPrice();
        Double other$discountPrice = other.getDiscountPrice();
        if (this$discountPrice == null ? other$discountPrice != null : !((Object)this$discountPrice).equals(other$discountPrice)) {
            return false;
        }
        Double this$updatePrice = this.getUpdatePrice();
        Double other$updatePrice = other.getUpdatePrice();
        if (this$updatePrice == null ? other$updatePrice != null : !((Object)this$updatePrice).equals(other$updatePrice)) {
            return false;
        }
        Double this$weight = this.getWeight();
        Double other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
            return false;
        }
        Integer this$goodsNum = this.getGoodsNum();
        Integer other$goodsNum = other.getGoodsNum();
        if (this$goodsNum == null ? other$goodsNum != null : !((Object)this$goodsNum).equals(other$goodsNum)) {
            return false;
        }
        Boolean this$needReceipt = this.getNeedReceipt();
        Boolean other$needReceipt = other.getNeedReceipt();
        if (this$needReceipt == null ? other$needReceipt != null : !((Object)this$needReceipt).equals(other$needReceipt)) {
            return false;
        }
        Boolean this$canReturn = this.getCanReturn();
        Boolean other$canReturn = other.getCanReturn();
        if (this$canReturn == null ? other$canReturn != null : !((Object)this$canReturn).equals(other$canReturn)) {
            return false;
        }
        Integer this$giftPoint = this.getGiftPoint();
        Integer other$giftPoint = other.getGiftPoint();
        if (this$giftPoint == null ? other$giftPoint != null : !((Object)this$giftPoint).equals(other$giftPoint)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$tradeSn = this.getTradeSn();
        String other$tradeSn = other.getTradeSn();
        if (this$tradeSn == null ? other$tradeSn != null : !this$tradeSn.equals(other$tradeSn)) {
            return false;
        }
        String this$storeId = this.getStoreId();
        String other$storeId = other.getStoreId();
        if (this$storeId == null ? other$storeId != null : !this$storeId.equals(other$storeId)) {
            return false;
        }
        String this$storeName = this.getStoreName();
        String other$storeName = other.getStoreName();
        if (this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName)) {
            return false;
        }
        String this$memberId = this.getMemberId();
        String other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
            return false;
        }
        String this$memberName = this.getMemberName();
        String other$memberName = other.getMemberName();
        if (this$memberName == null ? other$memberName != null : !this$memberName.equals(other$memberName)) {
            return false;
        }
        String this$orderStatus = this.getOrderStatus();
        String other$orderStatus = other.getOrderStatus();
        if (this$orderStatus == null ? other$orderStatus != null : !this$orderStatus.equals(other$orderStatus)) {
            return false;
        }
        String this$payStatus = this.getPayStatus();
        String other$payStatus = other.getPayStatus();
        if (this$payStatus == null ? other$payStatus != null : !this$payStatus.equals(other$payStatus)) {
            return false;
        }
        String this$deliverStatus = this.getDeliverStatus();
        String other$deliverStatus = other.getDeliverStatus();
        if (this$deliverStatus == null ? other$deliverStatus != null : !this$deliverStatus.equals(other$deliverStatus)) {
            return false;
        }
        String this$receivableNo = this.getReceivableNo();
        String other$receivableNo = other.getReceivableNo();
        if (this$receivableNo == null ? other$receivableNo != null : !this$receivableNo.equals(other$receivableNo)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        Date this$paymentTime = this.getPaymentTime();
        Date other$paymentTime = other.getPaymentTime();
        if (this$paymentTime == null ? other$paymentTime != null : !((Object)this$paymentTime).equals(other$paymentTime)) {
            return false;
        }
        String this$consigneeName = this.getConsigneeName();
        String other$consigneeName = other.getConsigneeName();
        if (this$consigneeName == null ? other$consigneeName != null : !this$consigneeName.equals(other$consigneeName)) {
            return false;
        }
        String this$consigneeMobile = this.getConsigneeMobile();
        String other$consigneeMobile = other.getConsigneeMobile();
        if (this$consigneeMobile == null ? other$consigneeMobile != null : !this$consigneeMobile.equals(other$consigneeMobile)) {
            return false;
        }
        String this$deliveryMethod = this.getDeliveryMethod();
        String other$deliveryMethod = other.getDeliveryMethod();
        if (this$deliveryMethod == null ? other$deliveryMethod != null : !this$deliveryMethod.equals(other$deliveryMethod)) {
            return false;
        }
        String this$consigneeAddressPath = this.getConsigneeAddressPath();
        String other$consigneeAddressPath = other.getConsigneeAddressPath();
        if (this$consigneeAddressPath == null ? other$consigneeAddressPath != null : !this$consigneeAddressPath.equals(other$consigneeAddressPath)) {
            return false;
        }
        String this$consigneeAddressIdPath = this.getConsigneeAddressIdPath();
        String other$consigneeAddressIdPath = other.getConsigneeAddressIdPath();
        if (this$consigneeAddressIdPath == null ? other$consigneeAddressIdPath != null : !this$consigneeAddressIdPath.equals(other$consigneeAddressIdPath)) {
            return false;
        }
        String this$consigneeDetail = this.getConsigneeDetail();
        String other$consigneeDetail = other.getConsigneeDetail();
        if (this$consigneeDetail == null ? other$consigneeDetail != null : !this$consigneeDetail.equals(other$consigneeDetail)) {
            return false;
        }
        String this$logisticsNo = this.getLogisticsNo();
        String other$logisticsNo = other.getLogisticsNo();
        if (this$logisticsNo == null ? other$logisticsNo != null : !this$logisticsNo.equals(other$logisticsNo)) {
            return false;
        }
        String this$logisticsCode = this.getLogisticsCode();
        String other$logisticsCode = other.getLogisticsCode();
        if (this$logisticsCode == null ? other$logisticsCode != null : !this$logisticsCode.equals(other$logisticsCode)) {
            return false;
        }
        String this$logisticsName = this.getLogisticsName();
        String other$logisticsName = other.getLogisticsName();
        if (this$logisticsName == null ? other$logisticsName != null : !this$logisticsName.equals(other$logisticsName)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$cancelReason = this.getCancelReason();
        String other$cancelReason = other.getCancelReason();
        if (this$cancelReason == null ? other$cancelReason != null : !this$cancelReason.equals(other$cancelReason)) {
            return false;
        }
        Date this$completeTime = this.getCompleteTime();
        Date other$completeTime = other.getCompleteTime();
        if (this$completeTime == null ? other$completeTime != null : !((Object)this$completeTime).equals(other$completeTime)) {
            return false;
        }
        Date this$logisticsTime = this.getLogisticsTime();
        Date other$logisticsTime = other.getLogisticsTime();
        if (this$logisticsTime == null ? other$logisticsTime != null : !((Object)this$logisticsTime).equals(other$logisticsTime)) {
            return false;
        }
        String this$payOrderNo = this.getPayOrderNo();
        String other$payOrderNo = other.getPayOrderNo();
        if (this$payOrderNo == null ? other$payOrderNo != null : !this$payOrderNo.equals(other$payOrderNo)) {
            return false;
        }
        String this$clientType = this.getClientType();
        String other$clientType = other.getClientType();
        if (this$clientType == null ? other$clientType != null : !this$clientType.equals(other$clientType)) {
            return false;
        }
        String this$parentOrderSn = this.getParentOrderSn();
        String other$parentOrderSn = other.getParentOrderSn();
        if (this$parentOrderSn == null ? other$parentOrderSn != null : !this$parentOrderSn.equals(other$parentOrderSn)) {
            return false;
        }
        String this$promotionId = this.getPromotionId();
        String other$promotionId = other.getPromotionId();
        if (this$promotionId == null ? other$promotionId != null : !this$promotionId.equals(other$promotionId)) {
            return false;
        }
        String this$orderType = this.getOrderType();
        String other$orderType = other.getOrderType();
        if (this$orderType == null ? other$orderType != null : !this$orderType.equals(other$orderType)) {
            return false;
        }
        String this$orderPromotionType = this.getOrderPromotionType();
        String other$orderPromotionType = other.getOrderPromotionType();
        if (this$orderPromotionType == null ? other$orderPromotionType != null : !this$orderPromotionType.equals(other$orderPromotionType)) {
            return false;
        }
        String this$priceDetail = this.getPriceDetail();
        String other$priceDetail = other.getPriceDetail();
        if (this$priceDetail == null ? other$priceDetail != null : !this$priceDetail.equals(other$priceDetail)) {
            return false;
        }
        String this$verificationCode = this.getVerificationCode();
        String other$verificationCode = other.getVerificationCode();
        if (this$verificationCode == null ? other$verificationCode != null : !this$verificationCode.equals(other$verificationCode)) {
            return false;
        }
        String this$distributionId = this.getDistributionId();
        String other$distributionId = other.getDistributionId();
        if (this$distributionId == null ? other$distributionId != null : !this$distributionId.equals(other$distributionId)) {
            return false;
        }
        String this$useStoreMemberCouponIds = this.getUseStoreMemberCouponIds();
        String other$useStoreMemberCouponIds = other.getUseStoreMemberCouponIds();
        if (this$useStoreMemberCouponIds == null ? other$useStoreMemberCouponIds != null : !this$useStoreMemberCouponIds.equals(other$useStoreMemberCouponIds)) {
            return false;
        }
        String this$usePlatformMemberCouponId = this.getUsePlatformMemberCouponId();
        String other$usePlatformMemberCouponId = other.getUsePlatformMemberCouponId();
        if (this$usePlatformMemberCouponId == null ? other$usePlatformMemberCouponId != null : !this$usePlatformMemberCouponId.equals(other$usePlatformMemberCouponId)) {
            return false;
        }
        String this$qrCode = this.getQrCode();
        String other$qrCode = other.getQrCode();
        if (this$qrCode == null ? other$qrCode != null : !this$qrCode.equals(other$qrCode)) {
            return false;
        }
        String this$storeAddressPath = this.getStoreAddressPath();
        String other$storeAddressPath = other.getStoreAddressPath();
        if (this$storeAddressPath == null ? other$storeAddressPath != null : !this$storeAddressPath.equals(other$storeAddressPath)) {
            return false;
        }
        String this$storeAddressMobile = this.getStoreAddressMobile();
        String other$storeAddressMobile = other.getStoreAddressMobile();
        if (this$storeAddressMobile == null ? other$storeAddressMobile != null : !this$storeAddressMobile.equals(other$storeAddressMobile)) {
            return false;
        }
        String this$storeAddressCenter = this.getStoreAddressCenter();
        String other$storeAddressCenter = other.getStoreAddressCenter();
        return !(this$storeAddressCenter == null ? other$storeAddressCenter != null : !this$storeAddressCenter.equals(other$storeAddressCenter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Order;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Double $flowPrice = this.getFlowPrice();
        result = result * 59 + ($flowPrice == null ? 43 : ((Object)$flowPrice).hashCode());
        Double $goodsPrice = this.getGoodsPrice();
        result = result * 59 + ($goodsPrice == null ? 43 : ((Object)$goodsPrice).hashCode());
        Double $freightPrice = this.getFreightPrice();
        result = result * 59 + ($freightPrice == null ? 43 : ((Object)$freightPrice).hashCode());
        Double $discountPrice = this.getDiscountPrice();
        result = result * 59 + ($discountPrice == null ? 43 : ((Object)$discountPrice).hashCode());
        Double $updatePrice = this.getUpdatePrice();
        result = result * 59 + ($updatePrice == null ? 43 : ((Object)$updatePrice).hashCode());
        Double $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        Integer $goodsNum = this.getGoodsNum();
        result = result * 59 + ($goodsNum == null ? 43 : ((Object)$goodsNum).hashCode());
        Boolean $needReceipt = this.getNeedReceipt();
        result = result * 59 + ($needReceipt == null ? 43 : ((Object)$needReceipt).hashCode());
        Boolean $canReturn = this.getCanReturn();
        result = result * 59 + ($canReturn == null ? 43 : ((Object)$canReturn).hashCode());
        Integer $giftPoint = this.getGiftPoint();
        result = result * 59 + ($giftPoint == null ? 43 : ((Object)$giftPoint).hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $tradeSn = this.getTradeSn();
        result = result * 59 + ($tradeSn == null ? 43 : $tradeSn.hashCode());
        String $storeId = this.getStoreId();
        result = result * 59 + ($storeId == null ? 43 : $storeId.hashCode());
        String $storeName = this.getStoreName();
        result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
        String $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
        String $memberName = this.getMemberName();
        result = result * 59 + ($memberName == null ? 43 : $memberName.hashCode());
        String $orderStatus = this.getOrderStatus();
        result = result * 59 + ($orderStatus == null ? 43 : $orderStatus.hashCode());
        String $payStatus = this.getPayStatus();
        result = result * 59 + ($payStatus == null ? 43 : $payStatus.hashCode());
        String $deliverStatus = this.getDeliverStatus();
        result = result * 59 + ($deliverStatus == null ? 43 : $deliverStatus.hashCode());
        String $receivableNo = this.getReceivableNo();
        result = result * 59 + ($receivableNo == null ? 43 : $receivableNo.hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        Date $paymentTime = this.getPaymentTime();
        result = result * 59 + ($paymentTime == null ? 43 : ((Object)$paymentTime).hashCode());
        String $consigneeName = this.getConsigneeName();
        result = result * 59 + ($consigneeName == null ? 43 : $consigneeName.hashCode());
        String $consigneeMobile = this.getConsigneeMobile();
        result = result * 59 + ($consigneeMobile == null ? 43 : $consigneeMobile.hashCode());
        String $deliveryMethod = this.getDeliveryMethod();
        result = result * 59 + ($deliveryMethod == null ? 43 : $deliveryMethod.hashCode());
        String $consigneeAddressPath = this.getConsigneeAddressPath();
        result = result * 59 + ($consigneeAddressPath == null ? 43 : $consigneeAddressPath.hashCode());
        String $consigneeAddressIdPath = this.getConsigneeAddressIdPath();
        result = result * 59 + ($consigneeAddressIdPath == null ? 43 : $consigneeAddressIdPath.hashCode());
        String $consigneeDetail = this.getConsigneeDetail();
        result = result * 59 + ($consigneeDetail == null ? 43 : $consigneeDetail.hashCode());
        String $logisticsNo = this.getLogisticsNo();
        result = result * 59 + ($logisticsNo == null ? 43 : $logisticsNo.hashCode());
        String $logisticsCode = this.getLogisticsCode();
        result = result * 59 + ($logisticsCode == null ? 43 : $logisticsCode.hashCode());
        String $logisticsName = this.getLogisticsName();
        result = result * 59 + ($logisticsName == null ? 43 : $logisticsName.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $cancelReason = this.getCancelReason();
        result = result * 59 + ($cancelReason == null ? 43 : $cancelReason.hashCode());
        Date $completeTime = this.getCompleteTime();
        result = result * 59 + ($completeTime == null ? 43 : ((Object)$completeTime).hashCode());
        Date $logisticsTime = this.getLogisticsTime();
        result = result * 59 + ($logisticsTime == null ? 43 : ((Object)$logisticsTime).hashCode());
        String $payOrderNo = this.getPayOrderNo();
        result = result * 59 + ($payOrderNo == null ? 43 : $payOrderNo.hashCode());
        String $clientType = this.getClientType();
        result = result * 59 + ($clientType == null ? 43 : $clientType.hashCode());
        String $parentOrderSn = this.getParentOrderSn();
        result = result * 59 + ($parentOrderSn == null ? 43 : $parentOrderSn.hashCode());
        String $promotionId = this.getPromotionId();
        result = result * 59 + ($promotionId == null ? 43 : $promotionId.hashCode());
        String $orderType = this.getOrderType();
        result = result * 59 + ($orderType == null ? 43 : $orderType.hashCode());
        String $orderPromotionType = this.getOrderPromotionType();
        result = result * 59 + ($orderPromotionType == null ? 43 : $orderPromotionType.hashCode());
        String $priceDetail = this.getPriceDetail();
        result = result * 59 + ($priceDetail == null ? 43 : $priceDetail.hashCode());
        String $verificationCode = this.getVerificationCode();
        result = result * 59 + ($verificationCode == null ? 43 : $verificationCode.hashCode());
        String $distributionId = this.getDistributionId();
        result = result * 59 + ($distributionId == null ? 43 : $distributionId.hashCode());
        String $useStoreMemberCouponIds = this.getUseStoreMemberCouponIds();
        result = result * 59 + ($useStoreMemberCouponIds == null ? 43 : $useStoreMemberCouponIds.hashCode());
        String $usePlatformMemberCouponId = this.getUsePlatformMemberCouponId();
        result = result * 59 + ($usePlatformMemberCouponId == null ? 43 : $usePlatformMemberCouponId.hashCode());
        String $qrCode = this.getQrCode();
        result = result * 59 + ($qrCode == null ? 43 : $qrCode.hashCode());
        String $storeAddressPath = this.getStoreAddressPath();
        result = result * 59 + ($storeAddressPath == null ? 43 : $storeAddressPath.hashCode());
        String $storeAddressMobile = this.getStoreAddressMobile();
        result = result * 59 + ($storeAddressMobile == null ? 43 : $storeAddressMobile.hashCode());
        String $storeAddressCenter = this.getStoreAddressCenter();
        result = result * 59 + ($storeAddressCenter == null ? 43 : $storeAddressCenter.hashCode());
        return result;
    }

    public String getSn() {
        return this.sn;
    }

    public String getTradeSn() {
        return this.tradeSn;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public String getPayStatus() {
        return this.payStatus;
    }

    public String getDeliverStatus() {
        return this.deliverStatus;
    }

    public String getReceivableNo() {
        return this.receivableNo;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public Date getPaymentTime() {
        return this.paymentTime;
    }

    public String getConsigneeName() {
        return this.consigneeName;
    }

    public String getConsigneeMobile() {
        return this.consigneeMobile;
    }

    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public String getConsigneeAddressPath() {
        return this.consigneeAddressPath;
    }

    public String getConsigneeAddressIdPath() {
        return this.consigneeAddressIdPath;
    }

    public String getConsigneeDetail() {
        return this.consigneeDetail;
    }

    public Double getFlowPrice() {
        return this.flowPrice;
    }

    public Double getGoodsPrice() {
        return this.goodsPrice;
    }

    public Double getFreightPrice() {
        return this.freightPrice;
    }

    public Double getDiscountPrice() {
        return this.discountPrice;
    }

    public Double getUpdatePrice() {
        return this.updatePrice;
    }

    public String getLogisticsNo() {
        return this.logisticsNo;
    }

    public String getLogisticsCode() {
        return this.logisticsCode;
    }

    public String getLogisticsName() {
        return this.logisticsName;
    }

    public Double getWeight() {
        return this.weight;
    }

    public Integer getGoodsNum() {
        return this.goodsNum;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getCancelReason() {
        return this.cancelReason;
    }

    public Date getCompleteTime() {
        return this.completeTime;
    }

    public Date getLogisticsTime() {
        return this.logisticsTime;
    }

    public String getPayOrderNo() {
        return this.payOrderNo;
    }

    public String getClientType() {
        return this.clientType;
    }

    public Boolean getNeedReceipt() {
        return this.needReceipt;
    }

    public String getParentOrderSn() {
        return this.parentOrderSn;
    }

    public String getPromotionId() {
        return this.promotionId;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public String getOrderPromotionType() {
        return this.orderPromotionType;
    }

    public String getPriceDetail() {
        return this.priceDetail;
    }

    public Boolean getCanReturn() {
        return this.canReturn;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public String getDistributionId() {
        return this.distributionId;
    }

    public String getUseStoreMemberCouponIds() {
        return this.useStoreMemberCouponIds;
    }

    public String getUsePlatformMemberCouponId() {
        return this.usePlatformMemberCouponId;
    }

    public String getQrCode() {
        return this.qrCode;
    }

    public String getStoreAddressPath() {
        return this.storeAddressPath;
    }

    public String getStoreAddressMobile() {
        return this.storeAddressMobile;
    }

    public String getStoreAddressCenter() {
        return this.storeAddressCenter;
    }

    public Integer getGiftPoint() {
        return this.giftPoint;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setTradeSn(String tradeSn) {
        this.tradeSn = tradeSn;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setMemberName(String memberName) {
        this.memberName = memberName;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
    }

    public void setDeliverStatus(String deliverStatus) {
        this.deliverStatus = deliverStatus;
    }

    public void setReceivableNo(String receivableNo) {
        this.receivableNo = receivableNo;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setPaymentTime(Date paymentTime) {
        this.paymentTime = paymentTime;
    }

    public void setConsigneeName(String consigneeName) {
        this.consigneeName = consigneeName;
    }

    public void setConsigneeMobile(String consigneeMobile) {
        this.consigneeMobile = consigneeMobile;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public void setConsigneeAddressPath(String consigneeAddressPath) {
        this.consigneeAddressPath = consigneeAddressPath;
    }

    public void setConsigneeAddressIdPath(String consigneeAddressIdPath) {
        this.consigneeAddressIdPath = consigneeAddressIdPath;
    }

    public void setConsigneeDetail(String consigneeDetail) {
        this.consigneeDetail = consigneeDetail;
    }

    public void setFlowPrice(Double flowPrice) {
        this.flowPrice = flowPrice;
    }

    public void setGoodsPrice(Double goodsPrice) {
        this.goodsPrice = goodsPrice;
    }

    public void setFreightPrice(Double freightPrice) {
        this.freightPrice = freightPrice;
    }

    public void setDiscountPrice(Double discountPrice) {
        this.discountPrice = discountPrice;
    }

    public void setUpdatePrice(Double updatePrice) {
        this.updatePrice = updatePrice;
    }

    public void setLogisticsNo(String logisticsNo) {
        this.logisticsNo = logisticsNo;
    }

    public void setLogisticsCode(String logisticsCode) {
        this.logisticsCode = logisticsCode;
    }

    public void setLogisticsName(String logisticsName) {
        this.logisticsName = logisticsName;
    }

    public void setWeight(Double weight) {
        this.weight = weight;
    }

    public void setGoodsNum(Integer goodsNum) {
        this.goodsNum = goodsNum;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setCancelReason(String cancelReason) {
        this.cancelReason = cancelReason;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }

    @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
    public void setLogisticsTime(Date logisticsTime) {
        this.logisticsTime = logisticsTime;
    }

    public void setPayOrderNo(String payOrderNo) {
        this.payOrderNo = payOrderNo;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setNeedReceipt(Boolean needReceipt) {
        this.needReceipt = needReceipt;
    }

    public void setParentOrderSn(String parentOrderSn) {
        this.parentOrderSn = parentOrderSn;
    }

    public void setPromotionId(String promotionId) {
        this.promotionId = promotionId;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public void setOrderPromotionType(String orderPromotionType) {
        this.orderPromotionType = orderPromotionType;
    }

    public void setPriceDetail(String priceDetail) {
        this.priceDetail = priceDetail;
    }

    public void setCanReturn(Boolean canReturn) {
        this.canReturn = canReturn;
    }

    public void setVerificationCode(String verificationCode) {
        this.verificationCode = verificationCode;
    }

    public void setDistributionId(String distributionId) {
        this.distributionId = distributionId;
    }

    public void setUseStoreMemberCouponIds(String useStoreMemberCouponIds) {
        this.useStoreMemberCouponIds = useStoreMemberCouponIds;
    }

    public void setUsePlatformMemberCouponId(String usePlatformMemberCouponId) {
        this.usePlatformMemberCouponId = usePlatformMemberCouponId;
    }

    public void setQrCode(String qrCode) {
        this.qrCode = qrCode;
    }

    public void setStoreAddressPath(String storeAddressPath) {
        this.storeAddressPath = storeAddressPath;
    }

    public void setStoreAddressMobile(String storeAddressMobile) {
        this.storeAddressMobile = storeAddressMobile;
    }

    public void setStoreAddressCenter(String storeAddressCenter) {
        this.storeAddressCenter = storeAddressCenter;
    }

    public void setGiftPoint(Integer giftPoint) {
        this.giftPoint = giftPoint;
    }

    public String toString() {
        return "Order(sn=" + this.getSn() + ", tradeSn=" + this.getTradeSn() + ", storeId=" + this.getStoreId() + ", storeName=" + this.getStoreName() + ", memberId=" + this.getMemberId() + ", memberName=" + this.getMemberName() + ", orderStatus=" + this.getOrderStatus() + ", payStatus=" + this.getPayStatus() + ", deliverStatus=" + this.getDeliverStatus() + ", receivableNo=" + this.getReceivableNo() + ", paymentMethod=" + this.getPaymentMethod() + ", paymentTime=" + this.getPaymentTime() + ", consigneeName=" + this.getConsigneeName() + ", consigneeMobile=" + this.getConsigneeMobile() + ", deliveryMethod=" + this.getDeliveryMethod() + ", consigneeAddressPath=" + this.getConsigneeAddressPath() + ", consigneeAddressIdPath=" + this.getConsigneeAddressIdPath() + ", consigneeDetail=" + this.getConsigneeDetail() + ", flowPrice=" + this.getFlowPrice() + ", goodsPrice=" + this.getGoodsPrice() + ", freightPrice=" + this.getFreightPrice() + ", discountPrice=" + this.getDiscountPrice() + ", updatePrice=" + this.getUpdatePrice() + ", logisticsNo=" + this.getLogisticsNo() + ", logisticsCode=" + this.getLogisticsCode() + ", logisticsName=" + this.getLogisticsName() + ", weight=" + this.getWeight() + ", goodsNum=" + this.getGoodsNum() + ", remark=" + this.getRemark() + ", cancelReason=" + this.getCancelReason() + ", completeTime=" + this.getCompleteTime() + ", logisticsTime=" + this.getLogisticsTime() + ", payOrderNo=" + this.getPayOrderNo() + ", clientType=" + this.getClientType() + ", needReceipt=" + this.getNeedReceipt() + ", parentOrderSn=" + this.getParentOrderSn() + ", promotionId=" + this.getPromotionId() + ", orderType=" + this.getOrderType() + ", orderPromotionType=" + this.getOrderPromotionType() + ", priceDetail=" + this.getPriceDetail() + ", canReturn=" + this.getCanReturn() + ", verificationCode=" + this.getVerificationCode() + ", distributionId=" + this.getDistributionId() + ", useStoreMemberCouponIds=" + this.getUseStoreMemberCouponIds() + ", usePlatformMemberCouponId=" + this.getUsePlatformMemberCouponId() + ", qrCode=" + this.getQrCode() + ", storeAddressPath=" + this.getStoreAddressPath() + ", storeAddressMobile=" + this.getStoreAddressMobile() + ", storeAddressCenter=" + this.getStoreAddressCenter() + ", giftPoint=" + this.getGiftPoint() + ")";
    }

    public Order() {
    }

    public Order(String sn, String tradeSn, String storeId, String storeName, String memberId, String memberName, String orderStatus, String payStatus, String deliverStatus, String receivableNo, String paymentMethod, Date paymentTime, String consigneeName, String consigneeMobile, String deliveryMethod, String consigneeAddressPath, String consigneeAddressIdPath, String consigneeDetail, Double flowPrice, Double goodsPrice, Double freightPrice, Double discountPrice, Double updatePrice, String logisticsNo, String logisticsCode, String logisticsName, Double weight, Integer goodsNum, String remark, String cancelReason, Date completeTime, Date logisticsTime, String payOrderNo, String clientType, Boolean needReceipt, String parentOrderSn, String promotionId, String orderType, String orderPromotionType, String priceDetail, Boolean canReturn, String verificationCode, String distributionId, String useStoreMemberCouponIds, String usePlatformMemberCouponId, String qrCode, String storeAddressPath, String storeAddressMobile, String storeAddressCenter, Integer giftPoint) {
        this.sn = sn;
        this.tradeSn = tradeSn;
        this.storeId = storeId;
        this.storeName = storeName;
        this.memberId = memberId;
        this.memberName = memberName;
        this.orderStatus = orderStatus;
        this.payStatus = payStatus;
        this.deliverStatus = deliverStatus;
        this.receivableNo = receivableNo;
        this.paymentMethod = paymentMethod;
        this.paymentTime = paymentTime;
        this.consigneeName = consigneeName;
        this.consigneeMobile = consigneeMobile;
        this.deliveryMethod = deliveryMethod;
        this.consigneeAddressPath = consigneeAddressPath;
        this.consigneeAddressIdPath = consigneeAddressIdPath;
        this.consigneeDetail = consigneeDetail;
        this.flowPrice = flowPrice;
        this.goodsPrice = goodsPrice;
        this.freightPrice = freightPrice;
        this.discountPrice = discountPrice;
        this.updatePrice = updatePrice;
        this.logisticsNo = logisticsNo;
        this.logisticsCode = logisticsCode;
        this.logisticsName = logisticsName;
        this.weight = weight;
        this.goodsNum = goodsNum;
        this.remark = remark;
        this.cancelReason = cancelReason;
        this.completeTime = completeTime;
        this.logisticsTime = logisticsTime;
        this.payOrderNo = payOrderNo;
        this.clientType = clientType;
        this.needReceipt = needReceipt;
        this.parentOrderSn = parentOrderSn;
        this.promotionId = promotionId;
        this.orderType = orderType;
        this.orderPromotionType = orderPromotionType;
        this.priceDetail = priceDetail;
        this.canReturn = canReturn;
        this.verificationCode = verificationCode;
        this.distributionId = distributionId;
        this.useStoreMemberCouponIds = useStoreMemberCouponIds;
        this.usePlatformMemberCouponId = usePlatformMemberCouponId;
        this.qrCode = qrCode;
        this.storeAddressPath = storeAddressPath;
        this.storeAddressMobile = storeAddressMobile;
        this.storeAddressCenter = storeAddressCenter;
        this.giftPoint = giftPoint;
    }

    public static class OrderBuilder {
        private String sn;
        private String tradeSn;
        private String storeId;
        private String storeName;
        private String memberId;
        private String memberName;
        private String orderStatus;
        private String payStatus;
        private String deliverStatus;
        private String receivableNo;
        private String paymentMethod;
        private Date paymentTime;
        private String consigneeName;
        private String consigneeMobile;
        private String deliveryMethod;
        private String consigneeAddressPath;
        private String consigneeAddressIdPath;
        private String consigneeDetail;
        private Double flowPrice;
        private Double goodsPrice;
        private Double freightPrice;
        private Double discountPrice;
        private Double updatePrice;
        private String logisticsNo;
        private String logisticsCode;
        private String logisticsName;
        private Double weight;
        private Integer goodsNum;
        private String remark;
        private String cancelReason;
        private Date completeTime;
        private Date logisticsTime;
        private String payOrderNo;
        private String clientType;
        private Boolean needReceipt;
        private String parentOrderSn;
        private String promotionId;
        private String orderType;
        private String orderPromotionType;
        private String priceDetail;
        private Boolean canReturn;
        private String verificationCode;
        private String distributionId;
        private String useStoreMemberCouponIds;
        private String usePlatformMemberCouponId;
        private String qrCode;
        private String storeAddressPath;
        private String storeAddressMobile;
        private String storeAddressCenter;
        private Integer giftPoint;

        OrderBuilder() {
        }

        public OrderBuilder sn(String sn) {
            this.sn = sn;
            return this;
        }

        public OrderBuilder tradeSn(String tradeSn) {
            this.tradeSn = tradeSn;
            return this;
        }

        public OrderBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public OrderBuilder storeName(String storeName) {
            this.storeName = storeName;
            return this;
        }

        public OrderBuilder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public OrderBuilder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public OrderBuilder orderStatus(String orderStatus) {
            this.orderStatus = orderStatus;
            return this;
        }

        public OrderBuilder payStatus(String payStatus) {
            this.payStatus = payStatus;
            return this;
        }

        public OrderBuilder deliverStatus(String deliverStatus) {
            this.deliverStatus = deliverStatus;
            return this;
        }

        public OrderBuilder receivableNo(String receivableNo) {
            this.receivableNo = receivableNo;
            return this;
        }

        public OrderBuilder paymentMethod(String paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
        public OrderBuilder paymentTime(Date paymentTime) {
            this.paymentTime = paymentTime;
            return this;
        }

        public OrderBuilder consigneeName(String consigneeName) {
            this.consigneeName = consigneeName;
            return this;
        }

        public OrderBuilder consigneeMobile(String consigneeMobile) {
            this.consigneeMobile = consigneeMobile;
            return this;
        }

        public OrderBuilder deliveryMethod(String deliveryMethod) {
            this.deliveryMethod = deliveryMethod;
            return this;
        }

        public OrderBuilder consigneeAddressPath(String consigneeAddressPath) {
            this.consigneeAddressPath = consigneeAddressPath;
            return this;
        }

        public OrderBuilder consigneeAddressIdPath(String consigneeAddressIdPath) {
            this.consigneeAddressIdPath = consigneeAddressIdPath;
            return this;
        }

        public OrderBuilder consigneeDetail(String consigneeDetail) {
            this.consigneeDetail = consigneeDetail;
            return this;
        }

        public OrderBuilder flowPrice(Double flowPrice) {
            this.flowPrice = flowPrice;
            return this;
        }

        public OrderBuilder goodsPrice(Double goodsPrice) {
            this.goodsPrice = goodsPrice;
            return this;
        }

        public OrderBuilder freightPrice(Double freightPrice) {
            this.freightPrice = freightPrice;
            return this;
        }

        public OrderBuilder discountPrice(Double discountPrice) {
            this.discountPrice = discountPrice;
            return this;
        }

        public OrderBuilder updatePrice(Double updatePrice) {
            this.updatePrice = updatePrice;
            return this;
        }

        public OrderBuilder logisticsNo(String logisticsNo) {
            this.logisticsNo = logisticsNo;
            return this;
        }

        public OrderBuilder logisticsCode(String logisticsCode) {
            this.logisticsCode = logisticsCode;
            return this;
        }

        public OrderBuilder logisticsName(String logisticsName) {
            this.logisticsName = logisticsName;
            return this;
        }

        public OrderBuilder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public OrderBuilder goodsNum(Integer goodsNum) {
            this.goodsNum = goodsNum;
            return this;
        }

        public OrderBuilder remark(String remark) {
            this.remark = remark;
            return this;
        }

        public OrderBuilder cancelReason(String cancelReason) {
            this.cancelReason = cancelReason;
            return this;
        }

        @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
        public OrderBuilder completeTime(Date completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        @JsonFormat(timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
        public OrderBuilder logisticsTime(Date logisticsTime) {
            this.logisticsTime = logisticsTime;
            return this;
        }

        public OrderBuilder payOrderNo(String payOrderNo) {
            this.payOrderNo = payOrderNo;
            return this;
        }

        public OrderBuilder clientType(String clientType) {
            this.clientType = clientType;
            return this;
        }

        public OrderBuilder needReceipt(Boolean needReceipt) {
            this.needReceipt = needReceipt;
            return this;
        }

        public OrderBuilder parentOrderSn(String parentOrderSn) {
            this.parentOrderSn = parentOrderSn;
            return this;
        }

        public OrderBuilder promotionId(String promotionId) {
            this.promotionId = promotionId;
            return this;
        }

        public OrderBuilder orderType(String orderType) {
            this.orderType = orderType;
            return this;
        }

        public OrderBuilder orderPromotionType(String orderPromotionType) {
            this.orderPromotionType = orderPromotionType;
            return this;
        }

        public OrderBuilder priceDetail(String priceDetail) {
            this.priceDetail = priceDetail;
            return this;
        }

        public OrderBuilder canReturn(Boolean canReturn) {
            this.canReturn = canReturn;
            return this;
        }

        public OrderBuilder verificationCode(String verificationCode) {
            this.verificationCode = verificationCode;
            return this;
        }

        public OrderBuilder distributionId(String distributionId) {
            this.distributionId = distributionId;
            return this;
        }

        public OrderBuilder useStoreMemberCouponIds(String useStoreMemberCouponIds) {
            this.useStoreMemberCouponIds = useStoreMemberCouponIds;
            return this;
        }

        public OrderBuilder usePlatformMemberCouponId(String usePlatformMemberCouponId) {
            this.usePlatformMemberCouponId = usePlatformMemberCouponId;
            return this;
        }

        public OrderBuilder qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        public OrderBuilder storeAddressPath(String storeAddressPath) {
            this.storeAddressPath = storeAddressPath;
            return this;
        }

        public OrderBuilder storeAddressMobile(String storeAddressMobile) {
            this.storeAddressMobile = storeAddressMobile;
            return this;
        }

        public OrderBuilder storeAddressCenter(String storeAddressCenter) {
            this.storeAddressCenter = storeAddressCenter;
            return this;
        }

        public OrderBuilder giftPoint(Integer giftPoint) {
            this.giftPoint = giftPoint;
            return this;
        }

        public Order build() {
            return new Order(this.sn, this.tradeSn, this.storeId, this.storeName, this.memberId, this.memberName, this.orderStatus, this.payStatus, this.deliverStatus, this.receivableNo, this.paymentMethod, this.paymentTime, this.consigneeName, this.consigneeMobile, this.deliveryMethod, this.consigneeAddressPath, this.consigneeAddressIdPath, this.consigneeDetail, this.flowPrice, this.goodsPrice, this.freightPrice, this.discountPrice, this.updatePrice, this.logisticsNo, this.logisticsCode, this.logisticsName, this.weight, this.goodsNum, this.remark, this.cancelReason, this.completeTime, this.logisticsTime, this.payOrderNo, this.clientType, this.needReceipt, this.parentOrderSn, this.promotionId, this.orderType, this.orderPromotionType, this.priceDetail, this.canReturn, this.verificationCode, this.distributionId, this.useStoreMemberCouponIds, this.usePlatformMemberCouponId, this.qrCode, this.storeAddressPath, this.storeAddressMobile, this.storeAddressCenter, this.giftPoint);
        }

        public String toString() {
            return "Order.OrderBuilder(sn=" + this.sn + ", tradeSn=" + this.tradeSn + ", storeId=" + this.storeId + ", storeName=" + this.storeName + ", memberId=" + this.memberId + ", memberName=" + this.memberName + ", orderStatus=" + this.orderStatus + ", payStatus=" + this.payStatus + ", deliverStatus=" + this.deliverStatus + ", receivableNo=" + this.receivableNo + ", paymentMethod=" + this.paymentMethod + ", paymentTime=" + this.paymentTime + ", consigneeName=" + this.consigneeName + ", consigneeMobile=" + this.consigneeMobile + ", deliveryMethod=" + this.deliveryMethod + ", consigneeAddressPath=" + this.consigneeAddressPath + ", consigneeAddressIdPath=" + this.consigneeAddressIdPath + ", consigneeDetail=" + this.consigneeDetail + ", flowPrice=" + this.flowPrice + ", goodsPrice=" + this.goodsPrice + ", freightPrice=" + this.freightPrice + ", discountPrice=" + this.discountPrice + ", updatePrice=" + this.updatePrice + ", logisticsNo=" + this.logisticsNo + ", logisticsCode=" + this.logisticsCode + ", logisticsName=" + this.logisticsName + ", weight=" + this.weight + ", goodsNum=" + this.goodsNum + ", remark=" + this.remark + ", cancelReason=" + this.cancelReason + ", completeTime=" + this.completeTime + ", logisticsTime=" + this.logisticsTime + ", payOrderNo=" + this.payOrderNo + ", clientType=" + this.clientType + ", needReceipt=" + this.needReceipt + ", parentOrderSn=" + this.parentOrderSn + ", promotionId=" + this.promotionId + ", orderType=" + this.orderType + ", orderPromotionType=" + this.orderPromotionType + ", priceDetail=" + this.priceDetail + ", canReturn=" + this.canReturn + ", verificationCode=" + this.verificationCode + ", distributionId=" + this.distributionId + ", useStoreMemberCouponIds=" + this.useStoreMemberCouponIds + ", usePlatformMemberCouponId=" + this.usePlatformMemberCouponId + ", qrCode=" + this.qrCode + ", storeAddressPath=" + this.storeAddressPath + ", storeAddressMobile=" + this.storeAddressMobile + ", storeAddressCenter=" + this.storeAddressCenter + ", giftPoint=" + this.giftPoint + ")";
        }
    }
}

