/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.order.order.entity.dto;

import cn.lili.common.utils.CurrencyUtil;
import cn.lili.modules.order.order.entity.dto.DiscountPriceItem;
import cn.lili.modules.promotion.entity.vos.PromotionSkuVO;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PriceDetailDTO
implements Serializable {
    private static final long serialVersionUID = 8808470688518188146L;
    @ApiModelProperty(value="\u8ba2\u5355\u539f\u59cb\u603b\u4ef7\u683c")
    private Double originalPrice = 0.0;
    @ApiModelProperty(value="\u5546\u54c1\u603b\u91d1\u989d\uff08\u5546\u54c1\u539f\u4ef7\uff09")
    private Double goodsPrice = 0.0;
    @ApiModelProperty(value="\u914d\u9001\u8d39")
    private Double freightPrice = 0.0;
    @ApiModelProperty(value="\u652f\u4ed8\u79ef\u5206")
    private Long payPoint = 0L;
    @ApiModelProperty(value="\u4f18\u60e0\u91d1\u989d")
    private Double discountPrice = 0.0;
    @ApiModelProperty(value="\u4f18\u60e0\u8be6\u60c5")
    private List<DiscountPriceItem> discountPriceDetail = new ArrayList<DiscountPriceItem>();
    @ApiModelProperty(value="\u4f18\u60e0\u5238\u91d1\u989d")
    private Double couponPrice = 0.0;
    @ApiModelProperty(value="\u5355\u54c1\u5206\u9500\u8fd4\u73b0\u652f\u51fa")
    private Double distributionCommission = 0.0;
    @ApiModelProperty(value="\u5e73\u53f0\u6536\u53d6\u4ea4\u6613\u4f63\u91d1\u6bd4\u4f8b")
    private Double platFormCommissionPoint = 0.0;
    @ApiModelProperty(value="\u5e73\u53f0\u6536\u53d6\u4ea4\u6613\u4f63\u91d1=(flowPrice(\u6d41\u6c34\u91d1\u989d) * platFormCommissionPoint(\u5e73\u53f0\u4f63\u91d1\u6bd4\u4f8b))/100")
    private Double platFormCommission = 0.0;
    @ApiModelProperty(value="\u5e73\u53f0\u4f18\u60e0\u5238 \u4f7f\u7528\u91d1\u989d")
    private Double siteCouponPrice = 0.0;
    @ApiModelProperty(value="\u7ad9\u70b9\u4f18\u60e0\u5238\u4f63\u91d1\u6bd4\u4f8b")
    private Double siteCouponPoint = 0.0;
    @ApiModelProperty(value="\u7ad9\u70b9\u4f18\u60e0\u5238\u4f63\u91d1")
    private Double siteCouponCommission = 0.0;
    @ApiModelProperty(value="\u8ba2\u5355\u4fee\u6539\u91d1\u989d")
    private Double updatePrice = 0.0;
    @ApiModelProperty(value="\u6d41\u6c34\u91d1\u989d(\u5165\u8d26 \u51fa\u5e10\u91d1\u989d) = goodsPrice(\u5546\u54c1\u603b\u91d1\u989d\uff08\u5546\u54c1\u539f\u4ef7\uff09) + freightPrice(\u914d\u9001\u8d39) - discountPrice(\u4f18\u60e0\u91d1\u989d) - couponPrice(\u4f18\u60e0\u5238\u91d1\u989d) + updatePrice(\u8ba2\u5355\u4fee\u6539\u91d1\u989d)")
    private Double flowPrice = 0.0;
    @ApiModelProperty(value="\u7ed3\u7b97\u4ef7\u683c \u4e0e \u5546\u5bb6/\u4f9b\u5e94\u5546 \u7ed3\u7b97\u4ef7\u683c\uff08\u4f8b\u5982\u79ef\u5206\u5546\u54c1/\u780d\u4ef7\u5546\u54c1\uff09")
    private Double settlementPrice = 0.0;
    @ApiModelProperty(value="\u6700\u7ec8\u7ed3\u7b97\u91d1\u989d = flowPrice(\u6d41\u6c34\u91d1\u989d) - platFormCommission(\u5e73\u53f0\u6536\u53d6\u4ea4\u6613\u4f63\u91d1) - distributionCommission(\u5355\u54c1\u5206\u9500\u8fd4\u73b0\u652f\u51fa)")
    private Double billPrice = 0.0;
    @ApiModelProperty(value="\u53c2\u4e0e\u7684\u4fc3\u9500\u6d3b\u52a8")
    private List<PromotionSkuVO> joinPromotion = new ArrayList<PromotionSkuVO>();

    public void setDiscountPriceItem(DiscountPriceItem discountPriceItem) {
        ArrayList<DiscountPriceItem> discountPriceItems = new ArrayList<DiscountPriceItem>();
        discountPriceItems.add(discountPriceItem);
        this.discountPriceDetail = discountPriceItems;
    }

    public void addDiscountPriceItem(DiscountPriceItem discountPriceItem) {
        this.discountPriceDetail.add(discountPriceItem);
    }

    public Double getOriginalPrice() {
        if (this.originalPrice == 0.0) {
            return this.flowPrice;
        }
        if (this.originalPrice < 0.0) {
            return 0.0;
        }
        return this.originalPrice;
    }

    public void setUpdatePrice(Double updatePrice) {
        this.updatePrice = updatePrice;
        this.recount();
    }

    public void recount() {
        this.flowPrice = CurrencyUtil.sub((double[])new double[]{CurrencyUtil.add((double[])new double[]{this.goodsPrice, this.freightPrice}), CurrencyUtil.add((double[])new double[]{this.discountPrice, this.couponPrice != null ? this.couponPrice : 0.0})});
        if (this.updatePrice != 0.0) {
            this.flowPrice = CurrencyUtil.add((double[])new double[]{this.flowPrice, this.updatePrice});
        }
        if (this.platFormCommissionPoint != null && this.getPlatFormCommissionPoint() > 0.0) {
            this.platFormCommission = CurrencyUtil.div((double)CurrencyUtil.mul((double)this.flowPrice, (double)this.platFormCommissionPoint), (double)100.0);
        }
        this.billPrice = this.settlementPrice > 0.0 ? this.settlementPrice : CurrencyUtil.sub((double[])new double[]{this.flowPrice, this.platFormCommission, this.distributionCommission});
    }

    public void increase(PriceDetailDTO priceDetailDTO) {
        this.originalPrice = CurrencyUtil.add((double[])new double[]{this.originalPrice, priceDetailDTO.getOriginalPrice()});
        this.goodsPrice = CurrencyUtil.add((double[])new double[]{this.goodsPrice, priceDetailDTO.getGoodsPrice()});
        this.freightPrice = CurrencyUtil.add((double[])new double[]{this.freightPrice, priceDetailDTO.getFreightPrice()});
        this.payPoint = this.payPoint + priceDetailDTO.getPayPoint();
        this.discountPrice = CurrencyUtil.add((double[])new double[]{this.discountPrice, priceDetailDTO.getDiscountPrice()});
        this.couponPrice = CurrencyUtil.add((double[])new double[]{this.couponPrice, priceDetailDTO.getCouponPrice()});
        this.distributionCommission = CurrencyUtil.add((double[])new double[]{this.distributionCommission, priceDetailDTO.getDistributionCommission()});
        this.platFormCommission = CurrencyUtil.add((double[])new double[]{this.platFormCommission, priceDetailDTO.getPlatFormCommission()});
        this.siteCouponPrice = CurrencyUtil.add((double[])new double[]{this.siteCouponPrice, priceDetailDTO.getSiteCouponPrice()});
        this.siteCouponPoint = priceDetailDTO.getSiteCouponPoint();
        this.siteCouponCommission = CurrencyUtil.add((double[])new double[]{this.siteCouponCommission, priceDetailDTO.getSiteCouponCommission()});
        this.updatePrice = CurrencyUtil.add((double[])new double[]{this.updatePrice, priceDetailDTO.getUpdatePrice()});
        this.flowPrice = CurrencyUtil.add((double[])new double[]{this.flowPrice, priceDetailDTO.getFlowPrice()});
        this.billPrice = CurrencyUtil.add((double[])new double[]{this.billPrice, priceDetailDTO.getBillPrice()});
        this.settlementPrice = CurrencyUtil.add((double[])new double[]{this.settlementPrice, priceDetailDTO.getSettlementPrice()});
        this.discountPriceDetail.addAll(priceDetailDTO.getDiscountPriceDetail());
    }

    public void accumulationPriceDTO(List<PriceDetailDTO> priceDetailDTOS) {
        for (PriceDetailDTO price : priceDetailDTOS) {
            this.increase(price);
        }
    }

    public Double getGoodsPrice() {
        if (this.goodsPrice == null || this.goodsPrice <= 0.0) {
            return 0.0;
        }
        return this.goodsPrice;
    }

    public Double getFreightPrice() {
        if (this.freightPrice == null || this.freightPrice <= 0.0) {
            return 0.0;
        }
        return this.freightPrice;
    }

    public Long getPayPoint() {
        if (this.payPoint == null || this.payPoint <= 0L) {
            return 0L;
        }
        return this.payPoint;
    }

    public Double getDiscountPrice() {
        if (this.discountPrice == null || this.discountPrice <= 0.0) {
            return 0.0;
        }
        return this.discountPrice;
    }

    public Double getCouponPrice() {
        if (this.couponPrice == null || this.couponPrice <= 0.0) {
            return 0.0;
        }
        return this.couponPrice;
    }

    public Double getDistributionCommission() {
        if (this.distributionCommission == null || this.distributionCommission <= 0.0) {
            return 0.0;
        }
        return this.distributionCommission;
    }

    public Double getPlatFormCommission() {
        if (this.platFormCommission == null || this.platFormCommission <= 0.0) {
            return 0.0;
        }
        return this.platFormCommission;
    }

    public Double getSiteCouponPrice() {
        if (this.siteCouponPrice == null || this.siteCouponPrice <= 0.0) {
            return 0.0;
        }
        return this.siteCouponPrice;
    }

    public Double getSiteCouponPoint() {
        if (this.siteCouponPoint == null || this.siteCouponPoint <= 0.0) {
            return 0.0;
        }
        return this.siteCouponPoint;
    }

    public Double getSiteCouponCommission() {
        if (this.siteCouponCommission == null || this.siteCouponCommission <= 0.0) {
            return 0.0;
        }
        return this.siteCouponCommission;
    }

    public Double getFlowPrice() {
        if (this.flowPrice == null || this.flowPrice <= 0.0) {
            return 0.0;
        }
        return this.flowPrice;
    }

    public Double getSettlementPrice() {
        if (this.settlementPrice == null || this.settlementPrice <= 0.0) {
            return 0.0;
        }
        return this.settlementPrice;
    }

    public Double getBillPrice() {
        if (this.billPrice == null || this.billPrice <= 0.0) {
            return 0.0;
        }
        return this.billPrice;
    }

    public Double getUpdatePrice() {
        if (this.updatePrice == null) {
            return 0.0;
        }
        return this.updatePrice;
    }

    public void setSiteCouponPrice(Double siteCouponPrice) {
        this.siteCouponPrice = siteCouponPrice;
        if (this.siteCouponPoint != null && this.siteCouponPoint != 0.0) {
            this.siteCouponCommission = CurrencyUtil.mul((double)siteCouponPrice, (double)this.siteCouponPoint);
        }
    }

    public void setSiteCouponPoint(Double siteCouponPoint) {
        this.siteCouponPoint = siteCouponPoint;
        if (siteCouponPoint != null && siteCouponPoint != 0.0) {
            this.siteCouponCommission = CurrencyUtil.div((double)CurrencyUtil.mul((double)this.siteCouponPrice, (double)siteCouponPoint), (double)100.0);
        }
    }

    public void setGoodsPrice(Double goodsPrice) {
        this.goodsPrice = goodsPrice;
        this.recount();
    }

    public void setFreightPrice(Double freightPrice) {
        this.freightPrice = freightPrice;
        this.recount();
    }

    public void setPayPoint(Long payPoint) {
        this.payPoint = payPoint;
    }

    public void setDiscountPrice(Double discountPrice) {
        this.discountPrice = discountPrice;
        this.promotionPriceHandler();
        this.recount();
    }

    public void setCouponPrice(Double couponPrice) {
        this.couponPrice = couponPrice;
        this.promotionPriceHandler();
        this.recount();
    }

    private void promotionPriceHandler() {
        if (this.couponPrice == null || this.discountPrice == null) {
            return;
        }
        double[] dArray = new double[]{this.couponPrice, this.discountPrice};
        if (CurrencyUtil.add((double[])dArray) > this.goodsPrice) {
            this.couponPrice = CurrencyUtil.sub((double[])new double[]{this.goodsPrice, this.discountPrice});
            this.setCouponPrice(this.couponPrice);
        }
    }

    public void setDistributionCommission(Double distributionCommission) {
        this.distributionCommission = distributionCommission;
        this.recount();
    }

    public void setPlatFormCommissionPoint(Double platFormCommissionPoint) {
        this.platFormCommissionPoint = platFormCommissionPoint;
        this.recount();
    }

    public void setPlatFormCommission(Double platFormCommission) {
        this.platFormCommission = platFormCommission;
        this.recount();
    }

    public void setSiteCouponCommission(Double siteCouponCommission) {
        this.siteCouponCommission = siteCouponCommission;
        this.recount();
    }

    public void setFlowPrice(Double flowPrice) {
        this.flowPrice = flowPrice;
        this.recount();
    }

    public void setSettlementPrice(Double settlementPrice) {
        this.settlementPrice = settlementPrice;
        this.recount();
    }

    public void setBillPrice(Double billPrice) {
        this.billPrice = billPrice;
        this.recount();
    }

    public List<DiscountPriceItem> getDiscountPriceDetail() {
        return this.discountPriceDetail;
    }

    public Double getPlatFormCommissionPoint() {
        return this.platFormCommissionPoint;
    }

    public List<PromotionSkuVO> getJoinPromotion() {
        return this.joinPromotion;
    }

    public void setOriginalPrice(Double originalPrice) {
        this.originalPrice = originalPrice;
    }

    public void setDiscountPriceDetail(List<DiscountPriceItem> discountPriceDetail) {
        this.discountPriceDetail = discountPriceDetail;
    }

    public void setJoinPromotion(List<PromotionSkuVO> joinPromotion) {
        this.joinPromotion = joinPromotion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PriceDetailDTO)) {
            return false;
        }
        PriceDetailDTO other = (PriceDetailDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$originalPrice = this.getOriginalPrice();
        Double other$originalPrice = other.getOriginalPrice();
        if (this$originalPrice == null ? other$originalPrice != null : !((Object)this$originalPrice).equals(other$originalPrice)) {
            return false;
        }
        Double this$goodsPrice = this.getGoodsPrice();
        Double other$goodsPrice = other.getGoodsPrice();
        if (this$goodsPrice == null ? other$goodsPrice != null : !((Object)this$goodsPrice).equals(other$goodsPrice)) {
            return false;
        }
        Double this$freightPrice = this.getFreightPrice();
        Double other$freightPrice = other.getFreightPrice();
        if (this$freightPrice == null ? other$freightPrice != null : !((Object)this$freightPrice).equals(other$freightPrice)) {
            return false;
        }
        Long this$payPoint = this.getPayPoint();
        Long other$payPoint = other.getPayPoint();
        if (this$payPoint == null ? other$payPoint != null : !((Object)this$payPoint).equals(other$payPoint)) {
            return false;
        }
        Double this$discountPrice = this.getDiscountPrice();
        Double other$discountPrice = other.getDiscountPrice();
        if (this$discountPrice == null ? other$discountPrice != null : !((Object)this$discountPrice).equals(other$discountPrice)) {
            return false;
        }
        Double this$couponPrice = this.getCouponPrice();
        Double other$couponPrice = other.getCouponPrice();
        if (this$couponPrice == null ? other$couponPrice != null : !((Object)this$couponPrice).equals(other$couponPrice)) {
            return false;
        }
        Double this$distributionCommission = this.getDistributionCommission();
        Double other$distributionCommission = other.getDistributionCommission();
        if (this$distributionCommission == null ? other$distributionCommission != null : !((Object)this$distributionCommission).equals(other$distributionCommission)) {
            return false;
        }
        Double this$platFormCommissionPoint = this.getPlatFormCommissionPoint();
        Double other$platFormCommissionPoint = other.getPlatFormCommissionPoint();
        if (this$platFormCommissionPoint == null ? other$platFormCommissionPoint != null : !((Object)this$platFormCommissionPoint).equals(other$platFormCommissionPoint)) {
            return false;
        }
        Double this$platFormCommission = this.getPlatFormCommission();
        Double other$platFormCommission = other.getPlatFormCommission();
        if (this$platFormCommission == null ? other$platFormCommission != null : !((Object)this$platFormCommission).equals(other$platFormCommission)) {
            return false;
        }
        Double this$siteCouponPrice = this.getSiteCouponPrice();
        Double other$siteCouponPrice = other.getSiteCouponPrice();
        if (this$siteCouponPrice == null ? other$siteCouponPrice != null : !((Object)this$siteCouponPrice).equals(other$siteCouponPrice)) {
            return false;
        }
        Double this$siteCouponPoint = this.getSiteCouponPoint();
        Double other$siteCouponPoint = other.getSiteCouponPoint();
        if (this$siteCouponPoint == null ? other$siteCouponPoint != null : !((Object)this$siteCouponPoint).equals(other$siteCouponPoint)) {
            return false;
        }
        Double this$siteCouponCommission = this.getSiteCouponCommission();
        Double other$siteCouponCommission = other.getSiteCouponCommission();
        if (this$siteCouponCommission == null ? other$siteCouponCommission != null : !((Object)this$siteCouponCommission).equals(other$siteCouponCommission)) {
            return false;
        }
        Double this$updatePrice = this.getUpdatePrice();
        Double other$updatePrice = other.getUpdatePrice();
        if (this$updatePrice == null ? other$updatePrice != null : !((Object)this$updatePrice).equals(other$updatePrice)) {
            return false;
        }
        Double this$flowPrice = this.getFlowPrice();
        Double other$flowPrice = other.getFlowPrice();
        if (this$flowPrice == null ? other$flowPrice != null : !((Object)this$flowPrice).equals(other$flowPrice)) {
            return false;
        }
        Double this$settlementPrice = this.getSettlementPrice();
        Double other$settlementPrice = other.getSettlementPrice();
        if (this$settlementPrice == null ? other$settlementPrice != null : !((Object)this$settlementPrice).equals(other$settlementPrice)) {
            return false;
        }
        Double this$billPrice = this.getBillPrice();
        Double other$billPrice = other.getBillPrice();
        if (this$billPrice == null ? other$billPrice != null : !((Object)this$billPrice).equals(other$billPrice)) {
            return false;
        }
        List<DiscountPriceItem> this$discountPriceDetail = this.getDiscountPriceDetail();
        List<DiscountPriceItem> other$discountPriceDetail = other.getDiscountPriceDetail();
        if (this$discountPriceDetail == null ? other$discountPriceDetail != null : !((Object)this$discountPriceDetail).equals(other$discountPriceDetail)) {
            return false;
        }
        List<PromotionSkuVO> this$joinPromotion = this.getJoinPromotion();
        List<PromotionSkuVO> other$joinPromotion = other.getJoinPromotion();
        return !(this$joinPromotion == null ? other$joinPromotion != null : !((Object)this$joinPromotion).equals(other$joinPromotion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PriceDetailDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $originalPrice = this.getOriginalPrice();
        result = result * 59 + ($originalPrice == null ? 43 : ((Object)$originalPrice).hashCode());
        Double $goodsPrice = this.getGoodsPrice();
        result = result * 59 + ($goodsPrice == null ? 43 : ((Object)$goodsPrice).hashCode());
        Double $freightPrice = this.getFreightPrice();
        result = result * 59 + ($freightPrice == null ? 43 : ((Object)$freightPrice).hashCode());
        Long $payPoint = this.getPayPoint();
        result = result * 59 + ($payPoint == null ? 43 : ((Object)$payPoint).hashCode());
        Double $discountPrice = this.getDiscountPrice();
        result = result * 59 + ($discountPrice == null ? 43 : ((Object)$discountPrice).hashCode());
        Double $couponPrice = this.getCouponPrice();
        result = result * 59 + ($couponPrice == null ? 43 : ((Object)$couponPrice).hashCode());
        Double $distributionCommission = this.getDistributionCommission();
        result = result * 59 + ($distributionCommission == null ? 43 : ((Object)$distributionCommission).hashCode());
        Double $platFormCommissionPoint = this.getPlatFormCommissionPoint();
        result = result * 59 + ($platFormCommissionPoint == null ? 43 : ((Object)$platFormCommissionPoint).hashCode());
        Double $platFormCommission = this.getPlatFormCommission();
        result = result * 59 + ($platFormCommission == null ? 43 : ((Object)$platFormCommission).hashCode());
        Double $siteCouponPrice = this.getSiteCouponPrice();
        result = result * 59 + ($siteCouponPrice == null ? 43 : ((Object)$siteCouponPrice).hashCode());
        Double $siteCouponPoint = this.getSiteCouponPoint();
        result = result * 59 + ($siteCouponPoint == null ? 43 : ((Object)$siteCouponPoint).hashCode());
        Double $siteCouponCommission = this.getSiteCouponCommission();
        result = result * 59 + ($siteCouponCommission == null ? 43 : ((Object)$siteCouponCommission).hashCode());
        Double $updatePrice = this.getUpdatePrice();
        result = result * 59 + ($updatePrice == null ? 43 : ((Object)$updatePrice).hashCode());
        Double $flowPrice = this.getFlowPrice();
        result = result * 59 + ($flowPrice == null ? 43 : ((Object)$flowPrice).hashCode());
        Double $settlementPrice = this.getSettlementPrice();
        result = result * 59 + ($settlementPrice == null ? 43 : ((Object)$settlementPrice).hashCode());
        Double $billPrice = this.getBillPrice();
        result = result * 59 + ($billPrice == null ? 43 : ((Object)$billPrice).hashCode());
        List<DiscountPriceItem> $discountPriceDetail = this.getDiscountPriceDetail();
        result = result * 59 + ($discountPriceDetail == null ? 43 : ((Object)$discountPriceDetail).hashCode());
        List<PromotionSkuVO> $joinPromotion = this.getJoinPromotion();
        result = result * 59 + ($joinPromotion == null ? 43 : ((Object)$joinPromotion).hashCode());
        return result;
    }

    public String toString() {
        return "PriceDetailDTO(originalPrice=" + this.getOriginalPrice() + ", goodsPrice=" + this.getGoodsPrice() + ", freightPrice=" + this.getFreightPrice() + ", payPoint=" + this.getPayPoint() + ", discountPrice=" + this.getDiscountPrice() + ", discountPriceDetail=" + this.getDiscountPriceDetail() + ", couponPrice=" + this.getCouponPrice() + ", distributionCommission=" + this.getDistributionCommission() + ", platFormCommissionPoint=" + this.getPlatFormCommissionPoint() + ", platFormCommission=" + this.getPlatFormCommission() + ", siteCouponPrice=" + this.getSiteCouponPrice() + ", siteCouponPoint=" + this.getSiteCouponPoint() + ", siteCouponCommission=" + this.getSiteCouponCommission() + ", updatePrice=" + this.getUpdatePrice() + ", flowPrice=" + this.getFlowPrice() + ", settlementPrice=" + this.getSettlementPrice() + ", billPrice=" + this.getBillPrice() + ", joinPromotion=" + this.getJoinPromotion() + ")";
    }
}

