/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.payment.dto;

import cn.lili.modules.payment.dto.OrderPaySuccessDTO;
import cn.lili.modules.payment.dto.PayParam;
import cn.lili.modules.payment.entity.dos.PaymentWakeup;
import cn.lili.modules.payment.entity.enums.PaymentMethodEnum;
import java.util.List;

public class PaymentSuccessParams {
    private String paymentMethod;
    private String receivableNo;
    private Double price;
    private PayParam payParam;
    private List<OrderPaySuccessDTO> subOrders;
    private String outTradeNo;

    public PaymentSuccessParams(PaymentWakeup paymentWakeup) {
        PayParam payParam = new PayParam();
        payParam.setOrderType(paymentWakeup.getOrderType());
        payParam.setClientType(paymentWakeup.getClientType());
        payParam.setSn(paymentWakeup.getOrderSn());
        this.payParam = payParam;
        this.paymentMethod = PaymentMethodEnum.paymentPluginOf(paymentWakeup.getPaymentMethod()).name();
        this.receivableNo = paymentWakeup.getPaymentReceivableNo();
        this.price = paymentWakeup.getPrice();
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public String getReceivableNo() {
        return this.receivableNo;
    }

    public Double getPrice() {
        return this.price;
    }

    public PayParam getPayParam() {
        return this.payParam;
    }

    public List<OrderPaySuccessDTO> getSubOrders() {
        return this.subOrders;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setReceivableNo(String receivableNo) {
        this.receivableNo = receivableNo;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setPayParam(PayParam payParam) {
        this.payParam = payParam;
    }

    public void setSubOrders(List<OrderPaySuccessDTO> subOrders) {
        this.subOrders = subOrders;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentSuccessParams)) {
            return false;
        }
        PaymentSuccessParams other = (PaymentSuccessParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$price = this.getPrice();
        Double other$price = other.getPrice();
        if (this$price == null ? other$price != null : !((Object)this$price).equals(other$price)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        String this$receivableNo = this.getReceivableNo();
        String other$receivableNo = other.getReceivableNo();
        if (this$receivableNo == null ? other$receivableNo != null : !this$receivableNo.equals(other$receivableNo)) {
            return false;
        }
        PayParam this$payParam = this.getPayParam();
        PayParam other$payParam = other.getPayParam();
        if (this$payParam == null ? other$payParam != null : !((Object)this$payParam).equals(other$payParam)) {
            return false;
        }
        List<OrderPaySuccessDTO> this$subOrders = this.getSubOrders();
        List<OrderPaySuccessDTO> other$subOrders = other.getSubOrders();
        if (this$subOrders == null ? other$subOrders != null : !((Object)this$subOrders).equals(other$subOrders)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        return !(this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaymentSuccessParams;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        String $receivableNo = this.getReceivableNo();
        result = result * 59 + ($receivableNo == null ? 43 : $receivableNo.hashCode());
        PayParam $payParam = this.getPayParam();
        result = result * 59 + ($payParam == null ? 43 : ((Object)$payParam).hashCode());
        List<OrderPaySuccessDTO> $subOrders = this.getSubOrders();
        result = result * 59 + ($subOrders == null ? 43 : ((Object)$subOrders).hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        return result;
    }

    public String toString() {
        return "PaymentSuccessParams(paymentMethod=" + this.getPaymentMethod() + ", receivableNo=" + this.getReceivableNo() + ", price=" + this.getPrice() + ", payParam=" + this.getPayParam() + ", subOrders=" + this.getSubOrders() + ", outTradeNo=" + this.getOutTradeNo() + ")";
    }

    public PaymentSuccessParams(String paymentMethod, String receivableNo, Double price, PayParam payParam, List<OrderPaySuccessDTO> subOrders, String outTradeNo) {
        this.paymentMethod = paymentMethod;
        this.receivableNo = receivableNo;
        this.price = price;
        this.payParam = payParam;
        this.subOrders = subOrders;
        this.outTradeNo = outTradeNo;
    }

    public PaymentSuccessParams() {
    }
}

