/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.payment.entity.enums;

public enum PaymentMethodEnum {
    WECHAT("wechatPlugin", "\u5fae\u4fe1"),
    ALIPAY("aliPayPlugin", "\u652f\u4ed8\u5b9d"),
    WALLET("walletPlugin", "\u4f59\u989d\u652f\u4ed8"),
    WECHAT_PARTNER("wechatPartnerPlugin", "\u5fae\u4fe1\u670d\u52a1\u5546\u652f\u4ed8"),
    BANK_TRANSFER("bankTransferPlugin", "\u7ebf\u4e0b\u8f6c\u8d26");

    private final String plugin;
    private final String paymentName;

    public String getPlugin() {
        return this.plugin;
    }

    public String paymentName() {
        return this.paymentName;
    }

    public static PaymentMethodEnum paymentPluginOf(String plugin) {
        for (PaymentMethodEnum value : PaymentMethodEnum.values()) {
            if (!value.plugin.equals(plugin)) continue;
            return value;
        }
        return null;
    }

    public static PaymentMethodEnum paymentNameOf(String name) {
        for (PaymentMethodEnum value : PaymentMethodEnum.values()) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        return null;
    }

    private PaymentMethodEnum(String plugin, String paymentName) {
        this.plugin = plugin;
        this.paymentName = paymentName;
    }
}

