/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.promotion.entity.dto.search;

import cn.hutool.core.text.CharSequenceUtil;
import cn.lili.modules.promotion.entity.dto.search.BasePromotionsSearchParams;
import cn.lili.modules.promotion.entity.enums.CouponGetEnum;
import cn.lili.modules.promotion.entity.enums.CouponRangeDayEnum;
import cn.lili.modules.promotion.entity.enums.CouponTypeEnum;
import cn.lili.modules.promotion.entity.enums.PromotionsScopeTypeEnum;
import cn.lili.modules.promotion.entity.enums.PromotionsStatusEnum;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

public class CouponSearchParams
extends BasePromotionsSearchParams
implements Serializable {
    private static final long serialVersionUID = 4566880169478260409L;
    private static final String PRICE_COLUMN = "price";
    private static final String RANGE_DAY_TYPE_COLUMN = "range_day_type";
    @ApiModelProperty(value="\u4f1a\u5458id")
    private String memberId;
    @ApiModelProperty(value="\u4f18\u60e0\u5238\u540d\u79f0")
    private String couponName;
    @ApiModelProperty(value="\u6d3b\u52a8\u7c7b\u578b")
    private String couponType;
    @ApiModelProperty(value="\u5173\u8054\u8303\u56f4\u7c7b\u578b")
    private String scopeType;
    @ApiModelProperty(value="\u8303\u56f4\u5173\u8054\u7684id")
    private String scopeId;
    @ApiModelProperty(value="\u9762\u989d,\u53ef\u4ee5\u4e3a\u8303\u56f4\uff0c\u598210_1000")
    private String price;
    @ApiModelProperty(value="\u53d1\u884c\u6570\u91cf,\u53ef\u4ee5\u4e3a\u8303\u56f4\uff0c\u598210_1000")
    private String publishNum;
    @ApiModelProperty(value="\u5df2\u88ab\u9886\u53d6\u7684\u6570\u91cf,\u53ef\u4ee5\u4e3a\u8303\u56f4\uff0c\u598210_1000")
    private String receivedNum;
    @ApiModelProperty(value="\u4f18\u60e0\u5238\u7c7b\u578b\uff0c\u5206\u4e3a\u514d\u8d39\u9886\u53d6\u548c\u6d3b\u52a8\u8d60\u9001")
    private String getType;

    @Override
    public <T> QueryWrapper<T> queryWrapper() {
        QueryWrapper queryWrapper = super.baseQueryWrapper();
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.couponName)) {
            queryWrapper.like((Object)"coupon_name", (Object)this.couponName);
        }
        if (this.memberId != null) {
            queryWrapper.eq((Object)"member_id", (Object)this.memberId);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.couponType)) {
            queryWrapper.eq((Object)"coupon_type", (Object)CouponTypeEnum.valueOf(this.couponType).name());
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.scopeType)) {
            queryWrapper.eq((Object)"scope_type", (Object)PromotionsScopeTypeEnum.valueOf(this.scopeType).name());
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.scopeId)) {
            queryWrapper.eq((Object)"scope_id", (Object)this.scopeId);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.getType)) {
            queryWrapper.eq((Object)"get_type", (Object)CouponGetEnum.valueOf(this.getType).name());
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.getPromotionStatus())) {
            queryWrapper.and(p -> {
                switch (PromotionsStatusEnum.valueOf(this.getPromotionStatus())) {
                    case NEW: {
                        p.nested(i -> {
                            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.gt((Object)"start_time", (Object)new Date())).gt((Object)"end_time", (Object)new Date());
                        });
                        break;
                    }
                    case START: {
                        ((QueryWrapper)p.nested(i -> {
                            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"start_time", (Object)new Date())).ge((Object)"end_time", (Object)new Date());
                        })).or(i -> {
                            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.gt((Object)"effective_days", (Object)0)).eq((Object)RANGE_DAY_TYPE_COLUMN, (Object)CouponRangeDayEnum.DYNAMICTIME.name());
                        });
                        break;
                    }
                    case END: {
                        p.nested(i -> {
                            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.lt((Object)"start_time", (Object)new Date())).lt((Object)"end_time", (Object)new Date());
                        });
                        break;
                    }
                    case CLOSE: {
                        p.nested(n -> {
                            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)n.nested(i -> {
                                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.isNull((Object)"start_time")).isNull((Object)"end_time")).eq((Object)RANGE_DAY_TYPE_COLUMN, (Object)CouponRangeDayEnum.FIXEDTIME.name());
                            })).or(i -> {
                                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)"effective_days", (Object)0)).eq((Object)RANGE_DAY_TYPE_COLUMN, (Object)CouponRangeDayEnum.DYNAMICTIME.name());
                            });
                        });
                        break;
                    }
                }
            });
        }
        if (this.getStartTime() != null) {
            queryWrapper.ge((Object)"start_time", (Object)new Date(this.getStartTime()));
        }
        if (this.getEndTime() != null) {
            queryWrapper.le((Object)"end_time", (Object)new Date(this.getEndTime()));
        }
        this.betweenWrapper(queryWrapper);
        queryWrapper.orderByDesc((Object)"create_time");
        return queryWrapper;
    }

    private <T> void betweenWrapper(QueryWrapper<T> queryWrapper) {
        String[] s;
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.publishNum)) {
            s = this.publishNum.split("_");
            if (s.length > 1) {
                queryWrapper.between((Object)"publish_num", (Object)s[0], (Object)s[1]);
            } else {
                queryWrapper.ge((Object)"publish_num", (Object)s[0]);
            }
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.price)) {
            s = this.price.split("_");
            if (s.length > 1) {
                queryWrapper.between((Object)PRICE_COLUMN, (Object)s[0], (Object)s[1]);
            } else {
                queryWrapper.ge((Object)PRICE_COLUMN, (Object)s[0]);
            }
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)this.receivedNum)) {
            s = this.receivedNum.split("_");
            if (s.length > 1) {
                queryWrapper.between((Object)"received_num", (Object)s[0], (Object)s[1]);
            } else {
                queryWrapper.ge((Object)"received_num", (Object)s[0]);
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouponSearchParams)) {
            return false;
        }
        CouponSearchParams other = (CouponSearchParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$memberId = this.getMemberId();
        String other$memberId = other.getMemberId();
        if (this$memberId == null ? other$memberId != null : !this$memberId.equals(other$memberId)) {
            return false;
        }
        String this$couponName = this.getCouponName();
        String other$couponName = other.getCouponName();
        if (this$couponName == null ? other$couponName != null : !this$couponName.equals(other$couponName)) {
            return false;
        }
        String this$couponType = this.getCouponType();
        String other$couponType = other.getCouponType();
        if (this$couponType == null ? other$couponType != null : !this$couponType.equals(other$couponType)) {
            return false;
        }
        String this$scopeType = this.getScopeType();
        String other$scopeType = other.getScopeType();
        if (this$scopeType == null ? other$scopeType != null : !this$scopeType.equals(other$scopeType)) {
            return false;
        }
        String this$scopeId = this.getScopeId();
        String other$scopeId = other.getScopeId();
        if (this$scopeId == null ? other$scopeId != null : !this$scopeId.equals(other$scopeId)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        String this$publishNum = this.getPublishNum();
        String other$publishNum = other.getPublishNum();
        if (this$publishNum == null ? other$publishNum != null : !this$publishNum.equals(other$publishNum)) {
            return false;
        }
        String this$receivedNum = this.getReceivedNum();
        String other$receivedNum = other.getReceivedNum();
        if (this$receivedNum == null ? other$receivedNum != null : !this$receivedNum.equals(other$receivedNum)) {
            return false;
        }
        String this$getType = this.getGetType();
        String other$getType = other.getGetType();
        return !(this$getType == null ? other$getType != null : !this$getType.equals(other$getType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CouponSearchParams;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $memberId = this.getMemberId();
        result = result * 59 + ($memberId == null ? 43 : $memberId.hashCode());
        String $couponName = this.getCouponName();
        result = result * 59 + ($couponName == null ? 43 : $couponName.hashCode());
        String $couponType = this.getCouponType();
        result = result * 59 + ($couponType == null ? 43 : $couponType.hashCode());
        String $scopeType = this.getScopeType();
        result = result * 59 + ($scopeType == null ? 43 : $scopeType.hashCode());
        String $scopeId = this.getScopeId();
        result = result * 59 + ($scopeId == null ? 43 : $scopeId.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        String $publishNum = this.getPublishNum();
        result = result * 59 + ($publishNum == null ? 43 : $publishNum.hashCode());
        String $receivedNum = this.getReceivedNum();
        result = result * 59 + ($receivedNum == null ? 43 : $receivedNum.hashCode());
        String $getType = this.getGetType();
        result = result * 59 + ($getType == null ? 43 : $getType.hashCode());
        return result;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getCouponName() {
        return this.couponName;
    }

    public String getCouponType() {
        return this.couponType;
    }

    @Override
    public String getScopeType() {
        return this.scopeType;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getPrice() {
        return this.price;
    }

    public String getPublishNum() {
        return this.publishNum;
    }

    public String getReceivedNum() {
        return this.receivedNum;
    }

    public String getGetType() {
        return this.getType;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setCouponName(String couponName) {
        this.couponName = couponName;
    }

    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }

    @Override
    public void setScopeType(String scopeType) {
        this.scopeType = scopeType;
    }

    public void setScopeId(String scopeId) {
        this.scopeId = scopeId;
    }

    public void setPrice(String price) {
        this.price = price;
    }

    public void setPublishNum(String publishNum) {
        this.publishNum = publishNum;
    }

    public void setReceivedNum(String receivedNum) {
        this.receivedNum = receivedNum;
    }

    public void setGetType(String getType) {
        this.getType = getType;
    }

    @Override
    public String toString() {
        return "CouponSearchParams(memberId=" + this.getMemberId() + ", couponName=" + this.getCouponName() + ", couponType=" + this.getCouponType() + ", scopeType=" + this.getScopeType() + ", scopeId=" + this.getScopeId() + ", price=" + this.getPrice() + ", publishNum=" + this.getPublishNum() + ", receivedNum=" + this.getReceivedNum() + ", getType=" + this.getGetType() + ")";
    }
}

