/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.promotion.tools;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.lili.common.enums.PromotionTypeEnum;
import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.modules.promotion.entity.dos.BasePromotions;
import cn.lili.modules.promotion.entity.dos.PromotionGoods;
import cn.lili.modules.promotion.entity.enums.PromotionsStatusEnum;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PromotionTools {
    private static final Logger log = LoggerFactory.getLogger(PromotionTools.class);
    public static final String START_TIME_COLUMN = "start_time";
    public static final String END_TIME_COLUMN = "end_time";
    public static final String PLATFORM_ID = "0";
    public static final String PLATFORM_NAME = "platform";

    private PromotionTools() {
        throw new IllegalStateException("Utility class");
    }

    public static void checkPromotionTime(Date startTime, Date endTime) {
        if (startTime == null) {
            throw new ServiceException(ResultCode.PROMOTION_TIME_NOT_EXIST);
        }
        DateTime now = DateUtil.date();
        if (now.after(startTime)) {
            throw new ServiceException(ResultCode.PROMOTION_START_TIME_ERROR);
        }
        if (endTime != null && now.after(endTime)) {
            throw new ServiceException(ResultCode.PROMOTION_END_TIME_ERROR);
        }
        if (endTime != null && startTime.after(endTime)) {
            throw new ServiceException(ResultCode.PROMOTION_TIME_ERROR);
        }
    }

    public static <T extends BasePromotions> QueryWrapper<T> checkActiveTime(Date startTime, Date endTime, PromotionTypeEnum typeEnum, String storeId, String activityId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (PromotionTypeEnum.SECKILL != typeEnum) {
            queryWrapper.nested(i -> {
                i.nested(i2 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i2.le((Object)START_TIME_COLUMN, (Object)startTime)).ge((Object)END_TIME_COLUMN, (Object)startTime);
                });
                i.or(i1 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i1.le((Object)START_TIME_COLUMN, (Object)endTime)).ge((Object)END_TIME_COLUMN, (Object)endTime);
                });
            });
        } else {
            ((QueryWrapper)queryWrapper.ge((Object)START_TIME_COLUMN, (Object)DateUtil.beginOfDay((Date)startTime))).le((Object)END_TIME_COLUMN, (Object)DateUtil.endOfDay((Date)endTime));
        }
        if (storeId != null) {
            queryWrapper.eq((Object)"store_id", (Object)storeId);
        }
        if (activityId != null) {
            queryWrapper.ne((Object)"id", (Object)activityId);
        }
        queryWrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.or(PromotionTools.queryPromotionStatus(PromotionsStatusEnum.NEW))).or(PromotionTools.queryPromotionStatus(PromotionsStatusEnum.START));
        });
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        return queryWrapper;
    }

    public static QueryWrapper<PromotionGoods> checkSkuDuplicate(List<PromotionTypeEnum> exceptType, List<String> skuIds, String activityId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (skuIds != null && !skuIds.isEmpty()) {
            queryWrapper.in((Object)"sku_id", skuIds);
        }
        if (CharSequenceUtil.isNotEmpty((CharSequence)activityId)) {
            queryWrapper.ne((Object)"id", (Object)activityId);
        }
        queryWrapper.and(i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.or(PromotionTools.queryPromotionStatus(PromotionsStatusEnum.START))).or(PromotionTools.queryPromotionStatus(PromotionsStatusEnum.NEW));
        });
        if (exceptType != null) {
            queryWrapper.notIn(!exceptType.isEmpty(), (Object)"promotion_type", (Collection)exceptType.stream().map(Enum::name).collect(Collectors.toList()));
        }
        queryWrapper.eq((Object)"delete_flag", (Object)false);
        return queryWrapper;
    }

    public static <T> Consumer<QueryWrapper<T>> queryPromotionStatus(PromotionsStatusEnum promotionsStatusEnum) {
        switch (promotionsStatusEnum) {
            case NEW: {
                return t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)t.nested(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.gt((Object)START_TIME_COLUMN, (Object)new Date())).gt((Object)END_TIME_COLUMN, (Object)new Date());
                    });
                };
            }
            case START: {
                return t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)t.nested(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.le((Object)START_TIME_COLUMN, (Object)new Date())).ge((Object)END_TIME_COLUMN, (Object)new Date());
                    });
                };
            }
            case END: {
                return t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)t.nested(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.lt((Object)START_TIME_COLUMN, (Object)new Date())).lt((Object)END_TIME_COLUMN, (Object)new Date());
                    });
                };
            }
            case CLOSE: {
                return t -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)t.nested(i -> {
                        QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)i.isNull((Object)START_TIME_COLUMN)).isNull((Object)END_TIME_COLUMN);
                    });
                };
            }
        }
        return null;
    }

    public static List<PromotionGoods> promotionGoodsInit(List<PromotionGoods> originList, BasePromotions promotion, PromotionTypeEnum promotionTypeEnum) {
        if (originList != null) {
            for (PromotionGoods promotionGoods : originList) {
                promotionGoods.setPromotionId(promotion.getId());
                if (CharSequenceUtil.isEmpty((CharSequence)promotionGoods.getStoreId())) {
                    promotionGoods.setStoreId(promotion.getStoreId());
                }
                if (CharSequenceUtil.isEmpty((CharSequence)promotionGoods.getStoreName())) {
                    promotionGoods.setStoreName(promotion.getStoreName());
                }
                promotionGoods.setTitle(promotion.getPromotionName());
                if (promotionGoods.getStartTime() == null || !PromotionTypeEnum.SECKILL.equals((Object)promotionTypeEnum)) {
                    promotionGoods.setStartTime(promotion.getStartTime());
                }
                if (promotionGoods.getStartTime() == null || !PromotionTypeEnum.SECKILL.equals((Object)promotionTypeEnum)) {
                    promotionGoods.setEndTime(promotion.getEndTime());
                }
                promotionGoods.setPromotionType(promotionTypeEnum.name());
                promotionGoods.setNum(0);
                promotionGoods.setDeleteFlag(promotion.getDeleteFlag());
            }
        }
        return originList;
    }

    public static int nextHour(String[] totalHours, Integer timeline) {
        int nextHour = 23;
        int[] hoursSored = Arrays.stream(totalHours).mapToInt(Integer::parseInt).toArray();
        Arrays.sort(hoursSored);
        for (int i : hoursSored) {
            if (timeline >= i) continue;
            nextHour = i;
            break;
        }
        return nextHour;
    }

    public static Map<String, Object> filterInvalidPromotionsMap(Map<String, Object> map) {
        if (CollUtil.isEmpty(map)) {
            return new HashMap<String, Object>();
        }
        try {
            return map.entrySet().stream().filter(Objects::nonNull).filter(i -> {
                JSONObject promotionsObj = JSONUtil.parseObj(i.getValue());
                BasePromotions basePromotions = (BasePromotions)((Object)((Object)promotionsObj.toBean(BasePromotions.class)));
                if (basePromotions != null && basePromotions.getStartTime() != null && basePromotions.getEndTime() != null) {
                    return basePromotions.getStartTime().getTime() <= System.currentTimeMillis() && basePromotions.getEndTime().getTime() >= System.currentTimeMillis();
                }
                return i.getValue() != null;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> newValue));
        }
        catch (Exception e) {
            log.error("\u8fc7\u6ee4\u65e0\u6548\u4fc3\u9500\u6d3b\u52a8\u51fa\u73b0\u5f02\u5e38\u3002\u5f02\u5e38\u4fc3\u9500\u4fe1\u606f\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f ", map, (Object)e);
            return new HashMap<String, Object>();
        }
    }

    public static boolean isPromotionsTypeNeedsToChecked(String key) {
        return !CharSequenceUtil.containsAny((CharSequence)key, (CharSequence[])new CharSequence[]{PromotionTypeEnum.COUPON.name(), PromotionTypeEnum.FULL_DISCOUNT.name()});
    }
}

