/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.search.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SqlFilter {
    private static final Set<String> SQL_KEYWORDS = new HashSet<String>(Arrays.asList("SELECT", "FROM", "WHERE", "AND", "OR", "NOT", "INSERT", "UPDATE", "DELETE", "CREATE", "TABLE", "INDEX", "VIEW", "DROP", "ALTER", "COLUMN", "ADD", "SET", "GROUP", "BY", "HAVING", "ORDER", "ASC", "DESC", "LIKE", "IN", "BETWEEN", "IS", "NULL", "TRUE", "FALSE", "JOIN", "LEFT", "RIGHT", "INNER", "OUTER", "FULL", "ON", "AS", "DISTINCT", "COUNT", "MAX", "MIN", "SUM", "AVG"));

    public static Boolean hit(String sql) {
        String[] tokens;
        for (String token : tokens = sql.split("\\s+")) {
            if (SQL_KEYWORDS.contains(token.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static String filterSql(String sql) {
        String[] tokens = sql.split("\\s+");
        StringBuilder filteredSql = new StringBuilder();
        for (String token : tokens) {
            if (SQL_KEYWORDS.contains(token.toUpperCase())) continue;
            filteredSql.append(token).append(" ");
        }
        return filteredSql.toString().trim();
    }
}

