/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.statistics.aop.aspect;

import cn.lili.cache.Cache;
import cn.lili.cache.CachePrefix;
import cn.lili.common.context.ThreadContextHolder;
import cn.lili.common.utils.IpUtils;
import cn.lili.common.utils.SpelUtil;
import cn.lili.common.vo.ResultMessage;
import cn.lili.modules.goods.entity.vos.GoodsSkuVO;
import cn.lili.modules.statistics.aop.PageViewPoint;
import cn.lili.modules.statistics.aop.enums.PageViewEnum;
import cn.lili.modules.statistics.util.StatisticsSuffix;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

@Aspect
@Configuration
public class PageViewInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PageViewInterceptor.class);
    @Autowired
    private Cache cache;

    @AfterReturning(returning="rvt", pointcut="@annotation(cn.lili.modules.statistics.aop.PageViewPoint)")
    public void interceptor(JoinPoint point, Object rvt) {
        String storeId;
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PageViewPoint pageViewPoint = method.getAnnotation(PageViewPoint.class);
        PageViewEnum pageViewEnum = pageViewPoint.type();
        String goodsId = null;
        switch (pageViewEnum) {
            case SKU: {
                ResultMessage skuRvt = (ResultMessage)rvt;
                if (skuRvt != null && skuRvt.getResult() != null && ((Map)skuRvt.getResult()).containsKey("data")) {
                    GoodsSkuVO goodsSkuDetail = (GoodsSkuVO)((Object)((Map)skuRvt.getResult()).get("data"));
                    storeId = goodsSkuDetail.getStoreId();
                    goodsId = goodsSkuDetail.getGoodsId();
                    break;
                }
            }
            case STORE: {
                Map<String, String> map = PageViewInterceptor.spelFormat(point);
                storeId = map.get("id");
                break;
            }
            default: {
                storeId = "-1";
            }
        }
        String ip = IpUtils.getIpAddress((HttpServletRequest)ThreadContextHolder.getHttpRequest());
        try {
            this.cache.incr(CachePrefix.PV.getPrefix() + StatisticsSuffix.suffix(), 172800L);
            this.cache.cumulative((Object)(CachePrefix.UV.getPrefix() + StatisticsSuffix.suffix()), (Object)ip);
            this.cache.incr(CachePrefix.STORE_PV.getPrefix() + StatisticsSuffix.suffix(storeId), 172800L);
            this.cache.cumulative((Object)(CachePrefix.STORE_UV.getPrefix() + StatisticsSuffix.suffix(storeId)), (Object)ip);
        }
        catch (Exception e) {
            log.error("\u9875\u9762\u51fa\u9519", (Throwable)e);
        }
    }

    private static Map<String, String> spelFormat(JoinPoint joinPoint) {
        HashMap<String, String> result = new HashMap<String, String>(2);
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        PageViewPoint pageViewPoint = signature.getMethod().getAnnotation(PageViewPoint.class);
        String id = SpelUtil.compileParams((JoinPoint)joinPoint, (String)pageViewPoint.id());
        result.put("id", id);
        return result;
    }
}

