/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.statistics.util;

import cn.lili.common.enums.ResultCode;
import cn.lili.common.exception.ServiceException;
import cn.lili.common.utils.StringUtils;
import cn.lili.modules.statistics.entity.dto.StatisticsQueryParam;
import cn.lili.modules.statistics.entity.enums.SearchTypeEnum;
import java.util.Calendar;
import java.util.Date;

public class StatisticsDateUtil {
    public static Date[] getDateArray(SearchTypeEnum searchTypeEnum) {
        Date[] dateArray = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (searchTypeEnum) {
            case TODAY: {
                dateArray[0] = calendar.getTime();
                calendar.set(11, 24);
                calendar.set(14, -1);
                dateArray[1] = calendar.getTime();
                break;
            }
            case YESTERDAY: {
                calendar.set(11, -24);
                dateArray[0] = calendar.getTime();
                calendar.set(11, 24);
                calendar.set(14, -1);
                dateArray[1] = calendar.getTime();
                break;
            }
            case LAST_SEVEN: {
                calendar.set(11, -168);
                dateArray[0] = calendar.getTime();
                calendar.set(11, 168);
                calendar.set(14, -1);
                dateArray[1] = calendar.getTime();
                break;
            }
            case LAST_THIRTY: {
                calendar.set(11, -720);
                dateArray[0] = calendar.getTime();
                calendar.set(11, 720);
                calendar.set(14, -1);
                dateArray[1] = calendar.getTime();
                break;
            }
            default: {
                throw new ServiceException(ResultCode.ERROR);
            }
        }
        return dateArray;
    }

    public static Date[] getDateArray(Integer year, Integer month) {
        Date[] dateArray = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, 0);
        dateArray[1] = calendar.getTime();
        calendar.set(2, calendar.get(2) - 1);
        dateArray[0] = calendar.getTime();
        return dateArray;
    }

    public static Date[] getDateArray(StatisticsQueryParam statisticsQueryParam) {
        if (StringUtils.isNotEmpty((CharSequence)statisticsQueryParam.getSearchType())) {
            return StatisticsDateUtil.getDateArray(SearchTypeEnum.valueOf(statisticsQueryParam.getSearchType()));
        }
        if (statisticsQueryParam.getMonth() != null && statisticsQueryParam.getYear() != null) {
            return StatisticsDateUtil.getDateArray(statisticsQueryParam.getYear(), statisticsQueryParam.getMonth());
        }
        Calendar calendar = Calendar.getInstance();
        return StatisticsDateUtil.getDateArray(calendar.get(1), calendar.get(2) + 1);
    }

    public static Date[] getDateArray(Date queryDate) {
        Date[] dateArray = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(queryDate);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        dateArray[0] = calendar.getTime();
        calendar.set(6, calendar.get(6) + 1);
        calendar.set(13, calendar.get(13) - 1);
        dateArray[1] = calendar.getTime();
        return dateArray;
    }
}

