/*
 * Decompiled with CFR 0.152.
 */
package cn.lili.modules.store.client;

import cn.lili.modules.store.entity.dos.Store;
import cn.lili.modules.store.entity.dos.StoreAddress;
import cn.lili.modules.store.entity.dos.StoreDetail;
import cn.lili.modules.store.entity.dto.StoreAfterSaleAddressDTO;
import cn.lili.modules.store.entity.dto.StoreDeliverGoodsAddressDTO;
import cn.lili.modules.store.entity.dto.StoreSettlementDay;
import cn.lili.modules.store.entity.params.StoreParams;
import cn.lili.modules.store.entity.vos.StoreDetailVO;
import cn.lili.modules.store.entity.vos.StoreSearchParams;
import cn.lili.modules.store.entity.vos.StoreVO;
import cn.lili.modules.store.fallback.StoreFallback;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="member-service", contextId="store", fallback=StoreFallback.class)
public interface StoreClient {
    @GetMapping(value={"/feign/store/query/getStoreDetailVO/{id}"})
    public StoreDetailVO getStoreDetailVO(@PathVariable(value="id") String var1);

    @GetMapping(value={"/feign/store/query/getStoreDetail"})
    public StoreDetail getStoreDetail(@RequestParam String var1);

    @GetMapping(value={"/feign/store/after-sale/address"})
    public StoreAfterSaleAddressDTO getStoreAfterSaleAddressDTO(@RequestParam String var1);

    @GetMapping(value={"/feign/store/settlement/day"})
    public List<StoreSettlementDay> getSettlementStore(@RequestParam int var1);

    @GetMapping(value={"/feign/store/{storeId}/getStore"})
    public StoreVO getStore(@PathVariable String var1);

    @PostMapping(value={"/feign/store/list"})
    public List<Store> list(@RequestBody StoreSearchParams var1);

    @PutMapping(value={"/feign/store/settlement/day"})
    public void updateSettlementDay(@RequestBody StoreParams var1);

    @PutMapping(value={"/feign/store/settlement/updateScore"})
    public boolean updateScore(@RequestBody StoreParams var1);

    @PutMapping(value={"/feign/store/settlement/updateStoreGoodsNum/{storeId}"})
    public void updateStoreGoodsNum(@PathVariable String var1, @RequestBody Long var2);

    @GetMapping(value={"/feign/store/{id}/getStoreAddress"})
    public StoreAddress getStoreAddress(@PathVariable String var1);

    @GetMapping(value={"/feign/store/{id}/getStoreDeliverGoodsAddressDto"})
    public StoreDeliverGoodsAddressDTO getStoreDeliverGoodsAddressDto(@PathVariable String var1);

    @GetMapping(value={"/feign/store/getStoreSubMchid"})
    public String getStoreSubMchid(@RequestParam String var1);
}

