package org.apache.shardingsphere.transaction.base.seata.at;

import io.seata.tm.api.GlobalTransaction;
import io.seata.tm.api.GlobalTransactionContext;

final class SeataTransactionHolder {
    private static final ThreadLocal<GlobalTransaction> CONTEXT = new ThreadLocal();

    SeataTransactionHolder() {
    }

    static void set(GlobalTransaction transaction) {
        CONTEXT.set(transaction);
    }

    static GlobalTransaction get() {
        GlobalTransaction globalTransaction = CONTEXT.get();
        if (globalTransaction == null) {
            globalTransaction = GlobalTransactionContext.getCurrentOrCreate();
        }
        return globalTransaction;
    }

    static void clear() {
        CONTEXT.remove();
    }
}

