package cn.tuia.mango.context.service;

import cn.tuia.mango.context.mapper.BaseMybatisInternalMapper;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.page.PageData;

import java.util.List;

/**
 * 业务逻辑
 *
 * @author lijicong
 * @since 2020-03-19
 */
public interface BaseMybatisInternalService<M extends BaseMybatisInternalMapper<T>, T extends BaseDomain> //
        extends BaseService {

    /**
     * 获取Service对应的Mapper
     *
     * @return
     */
    M getMapper();

    // wrap dao generator methods

    int deleteByPrimaryKey(Long id);

    int insert(T domain);

    int insertSelective(T domain);

    T getById(Long id);

    int updateByPrimaryKeySelective(T domain);

    int updateByPrimaryKey(T domain);

    int save(T domain);

    // ext methods

    List<T> list();

    List<T> list(T query);

    List<T> list(T query, int size);

    T getOne(T query);

    long count(T query);

    PageData<T> page(T query, int page, int size);

    PageData<T> page(T query);

    T add(T domain);

    T edit(T domain);
}
