/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.service.impl;

import cn.tuia.mango.context.mapper.BaseMybatisInternalMapper;
import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.context.service.impl.BaseServiceImpl;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.page.PageData;
import cn.tuia.mango.core.domain.page.PageParam;
import cn.tuia.mango.core.util.TypeKit;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class BaseMybatisInternalServiceImpl<M extends BaseMybatisInternalMapper<T>, T extends BaseDomain>
extends BaseServiceImpl
implements BaseMybatisInternalService<M, T> {
    protected M mapper;
    private Type[] typeArray;
    private Class<T> domainClazz;

    @Autowired
    public void setMapper(M mapper) {
        this.mapper = mapper;
    }

    @Override
    public M getMapper() {
        return this.mapper;
    }

    protected Type[] getTypeArray() {
        if (this.typeArray == null) {
            this.typeArray = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        }
        return TypeKit.getActualTypes(this.getClass());
    }

    protected Class<T> getDomainClazz() {
        if (this.domainClazz == null) {
            this.domainClazz = (Class)this.getTypeArray()[1];
        }
        return this.domainClazz;
    }

    protected T query() {
        return this.newDomainIfNull(null);
    }

    protected T newDomain() {
        return this.newDomainIfNull(null);
    }

    protected T newDomainIfNull(T model) {
        if (model == null) {
            try {
                model = (BaseDomain)this.getDomainClazz().newInstance();
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return model;
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        Assert.notNull((Object)id, (String)"id must not be null");
        if (this.log.isDebugEnabled()) {
            this.log.debug("\u7269\u7406\u5220\u9664\u5bf9\u8c61 id={}", (Object)id);
        }
        return this.getMapper().deleteByPrimaryKey(id);
    }

    @Override
    public int insert(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        return this.getMapper().insert(domain);
    }

    @Override
    public int insertSelective(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        return this.getMapper().insertSelective(domain);
    }

    @Override
    public int insertBatch(List<T> list) {
        Assert.notEmpty(list, (String)"list must not be empty");
        Assert.isTrue((list.size() <= 500 ? 1 : 0) != 0, (String)"list must less than 500");
        return this.getMapper().insertBatch(list);
    }

    @Override
    public T getById(Long id) {
        Assert.notNull((Object)id, (String)"id must not be null");
        return this.getMapper().selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        Assert.notNull((Object)domain.getId(), (String)"domain.id must not be null");
        return this.getMapper().updateByPrimaryKeySelective(domain);
    }

    @Override
    public int updateByPrimaryKey(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        Assert.notNull((Object)domain.getId(), (String)"domain.id must not be null");
        return this.getMapper().updateByPrimaryKey(domain);
    }

    @Override
    public int save(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        if (domain.getId() == null) {
            return this.getMapper().insertSelective(domain);
        }
        return this.getMapper().updateByPrimaryKeySelective(domain);
    }

    @Override
    public List<T> list() {
        T query = this.newDomain();
        query.setCurrentAndSize(1, 500);
        return this.getMapper().selectList(query);
    }

    @Override
    public List<T> list(T query) {
        query = this.newDomainIfNull(query);
        return this.getMapper().selectList(query);
    }

    @Override
    public List<T> list(T query, int size) {
        query = this.newDomainIfNull(query);
        query.setCurrentAndSize(1, size);
        return this.getMapper().selectList(query);
    }

    @Override
    public List<T> listByIds(List<Long> ids) {
        T query = this.newDomain();
        query.setIds(ids);
        return this.getMapper().selectList(query);
    }

    @Override
    public Map<Long, T> map(T query) {
        query = this.newDomainIfNull(query);
        List<T> list = this.getMapper().selectList(query);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(BaseDomain::getId, e -> e, (o, n) -> n));
    }

    @Override
    public Map<Long, T> mapByIds(List<Long> ids) {
        T query = this.newDomain();
        query.setIds(ids);
        List<T> list = this.getMapper().selectList(query);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(BaseDomain::getId, e -> e, (o, n) -> n));
    }

    @Override
    public T getOne(T query) {
        query = this.newDomainIfNull(query);
        query.setCurrentAndSize(1, 1);
        List<T> result = this.getMapper().selectList(query);
        if (CollectionUtils.isEmpty(result)) {
            return null;
        }
        return (T)((BaseDomain)result.get(0));
    }

    @Override
    public long count(T query) {
        query = this.newDomainIfNull(query);
        return this.getMapper().selectCount(query);
    }

    @Override
    public PageData<T> page(T query, int page, int size) {
        query = this.newDomainIfNull(query);
        query.setCurrentAndSize(page, size);
        return this.doFindPage(query);
    }

    @Override
    public PageData<T> page(T query) {
        if ((query = this.newDomainIfNull(query)).getPageParam() == null) {
            query.setPageParam(new PageParam());
        }
        return this.doFindPage(query);
    }

    protected PageData<T> doFindPage(T query) {
        PageData pageResult = new PageData();
        long total = this.getMapper().selectCount(query);
        if (total > 0L) {
            List<T> records = this.getMapper().selectList(query);
            pageResult.setRecords(records);
        }
        pageResult.setTotal(total);
        return pageResult;
    }

    @Override
    public T add(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        this.getMapper().insertSelective(domain);
        return domain;
    }

    @Override
    public T edit(T domain) {
        Assert.notNull(domain, (String)"domain must not be null");
        Assert.notNull((Object)domain.getId(), (String)"domain.id must not be null");
        this.getMapper().updateByPrimaryKeySelective(domain);
        return domain;
    }

    @Override
    public int deleteLogically(Long id) {
        Assert.notNull((Object)id, (String)"id must not be null");
        T domain = this.newDomain();
        domain.setId(id);
        domain.setIsDeleted(Integer.valueOf(1));
        return this.getMapper().updateByPrimaryKeySelective(domain);
    }
}

