/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.remote.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.tuia.mango.core.enums.CacheEnumerable;
import cn.tuia.mango.core.enums.support.ErrorCode;
import cn.tuia.mango.core.exception.CheckedException;
import cn.tuia.mango.core.exception.CodeException;
import cn.tuia.mango.core.remote.RedisLockCallback;
import cn.tuia.mango.core.remote.ServiceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected RedisAtomicClient redisAtomicClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T lock(RedisLockCallback<T> callback, CacheEnumerable cacheEnum, Object ... keySuffix) throws BizException {
        RedisLock lock = this.redisAtomicClient.getLock(cacheEnum.generateKey(keySuffix), cacheEnum.getUnit().toSeconds(cacheEnum.getTime()));
        if (null == lock) {
            throw new BizException(ErrorCode.E0400004.getDescription()).withCode(ErrorCode.E0400004.getCode());
        }
        try {
            Object object = callback.doInRedisLock();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    protected <R> R execute(ServiceCallback<R> callable, Object ... param) throws BizException {
        Object result = null;
        try {
            result = callable.doInService();
        }
        catch (Exception e) {
            this.wrapAndThowBizException(e);
        }
        return (R)result;
    }

    public void wrapAndThowBizException(Exception e) throws BizException {
        if (e instanceof CodeException) {
            CodeException ce = (CodeException)e;
            this.log.info("\u53d1\u751f\u5185\u90e8\u9519\u8bef, because of=[{}]", (Throwable)ce);
            throw new BizException(ce.getMessage()).withCode(ce.getCode());
        }
        if (e instanceof CheckedException) {
            CheckedException ce = (CheckedException)e;
            this.log.info("\u53d1\u751f\u5185\u90e8\u9519\u8bef, because of=[{}]", (Throwable)ce);
            throw new BizException(ce.getMessage()).withCode(ce.getCode());
        }
        this.log.warn("happen unKnow error", (Throwable)e);
        throw new BizException(ErrorCode.E9999999.getDescription()).withCode(ErrorCode.E9999999.getCode());
    }
}

