package cn.tuia.mango.context.remote.impl;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import cn.tuia.mango.core.enums.CacheEnumerable;
import cn.tuia.mango.core.enums.support.ErrorCode;
import cn.tuia.mango.core.exception.CheckedException;
import cn.tuia.mango.core.exception.CodeException;
import cn.tuia.mango.core.remote.RedisLockCallback;
import cn.tuia.mango.core.remote.ServiceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author lijicong
 * @since 2020-03-21
 */
public abstract class AbstractRemoteService {

    protected final Logger log = LoggerFactory.getLogger(getClass());

    protected RedisAtomicClient redisAtomicClient;

    protected <T> T lock(RedisLockCallback<T> callback, CacheEnumerable cacheEnum, Object... keySuffix) throws BizException {
        RedisLock lock = redisAtomicClient.getLock(
                cacheEnum.generateKey(keySuffix),
                cacheEnum.getUnit().toSeconds(cacheEnum.getTime()));
        if (null == lock) {
            throw new BizException(ErrorCode.E0400004.getDescription()).withCode(ErrorCode.E0400004.getCode());
        }
        try {
            return callback.doInRedisLock();
        } finally {
            lock.unlock();
        }
    }

    protected <R> R execute(ServiceCallback<R> callable, Object... param) throws BizException {
        R result = null;
        try {
            result = callable.doInService();
        } catch (Exception e) {
            wrapAndThowBizException(e);
        }
        return result;
    }

    public void wrapAndThowBizException(Exception e) throws BizException {
        if (e instanceof CodeException) {
            CodeException ce = (CodeException) e;
            log.info("发生内部错误, because of=[{}]", ce);
            throw new BizException(ce.getMessage()).withCode(ce.getCode());
        } else if (e instanceof CheckedException) {
            CheckedException ce = (CheckedException) e;
            log.info("发生内部错误, because of=[{}]", ce);
            throw new BizException(ce.getMessage()).withCode(ce.getCode());
        } else {
            log.warn("happen unKnow error", e);
            throw new BizException(ErrorCode.E9999999.getDescription()).withCode(ErrorCode.E9999999.getCode());
        }
    }

}
