package cn.tuia.mango.context.remote.impl;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.remote.BaseRemoteService;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/**
 * @author lijicong
 * @since 2020-03-21
 */
public abstract class AbstractRemoteServiceImpl<T extends BaseDomain, S extends BaseMybatisInternalService<?, T>,
        QueryDTO extends Serializable, FormDTO extends Serializable, DTO extends Serializable> //
        extends AbstractRemoteService
        implements BaseRemoteService<QueryDTO, FormDTO, DTO> {

    private Type[] typeArray;

    private Class<T> domainClazz;
    private Class<QueryDTO> queryDTOClazz;
    private Class<FormDTO> formDTOClazz;
    private Class<DTO> DTOClazz;

    @Autowired
    protected S service;

    public S getService() {
        return service;
    }

    // 泛型处理
    @SuppressWarnings("unchecked")
    protected Type[] getTypeArray() {
        if (typeArray == null) {
            typeArray = ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments();
        }
        return typeArray;
    }

    @SuppressWarnings("unchecked")
    protected Class<T> getDomainClazz() {
        if (domainClazz == null) {
            domainClazz = (Class<T>) getTypeArray()[0];
        }
        return domainClazz;
    }

    @SuppressWarnings("unchecked")
    protected Class<QueryDTO> getQueryDTOClazz() {
        if (queryDTOClazz == null) {
            queryDTOClazz = (Class<QueryDTO>) getTypeArray()[2];
        }
        return queryDTOClazz;
    }

    @SuppressWarnings("unchecked")
    protected Class<FormDTO> getFormDTOClazz() {
        if (formDTOClazz == null) {
            formDTOClazz = (Class<FormDTO>) getTypeArray()[3];
        }
        return formDTOClazz;
    }

    @SuppressWarnings("unchecked")
    protected Class<DTO> getDTOClazz() {
        if (DTOClazz == null) {
            DTOClazz = (Class<DTO>) getTypeArray()[4];
        }
        return DTOClazz;
    }


    @Override
    public List<DTO> queryList(QueryDTO queryDTO) {
        T query = BeanUtils.copy(queryDTO, getDomainClazz());
        List<T> list = getService().list(query);
        return BeanUtils.copyList(list, getDTOClazz());
    }

    @Override
    public long queryCount(QueryDTO queryDTO) {
        T query = BeanUtils.copy(queryDTO, getDomainClazz());
        return getService().count(query);
    }

    @Override
    public int save(FormDTO formDTO) {
        T domain = BeanUtils.copy(formDTO, getDomainClazz());
        return getService().save(domain);
    }

    @Override
    public DTO queryById(Long id) {
        T domain = getService().getById(id);
        return BeanUtils.copy(domain, getDTOClazz());
    }
}
