package cn.tuia.mango.context.validator.page;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class OrderValidator implements ConstraintValidator<Order, String> {
    
    private Set<String> values;

    @Override
    public void initialize(Order order) {
        values = Arrays.stream(order.accepts()).map(String::toUpperCase).collect(Collectors.toSet());
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        return values.contains(value.toUpperCase());
    }
}
