/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.web.controller;

import cn.com.duiba.wolf.utils.BeanUtils;
import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.BaseFormDomain;
import cn.tuia.mango.core.domain.BaseQueryDomain;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import cn.tuia.mango.core.domain.page.PageParam;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseFrontController<Query extends BaseQueryDomain, Form extends BaseFormDomain, T extends BaseDomain, S extends BaseMybatisInternalService<?, T>> {
    protected S service;
    protected Type[] typeArray;
    protected Class<Query> queryClazz;
    protected Class<Form> formClazz;
    protected Class<T> domainClazz;

    @Autowired
    public void setService(S service) {
        this.service = service;
    }

    public S getService() {
        return this.service;
    }

    protected Type[] getTypeArray() {
        if (this.typeArray == null) {
            this.typeArray = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        }
        return this.typeArray;
    }

    public Class<Query> getQueryClazz() {
        if (this.queryClazz == null) {
            this.queryClazz = (Class)this.getTypeArray()[0];
        }
        return this.queryClazz;
    }

    public Class<Form> getFormClazz() {
        if (this.formClazz == null) {
            this.formClazz = (Class)this.getTypeArray()[1];
        }
        return this.formClazz;
    }

    public Class<T> getDomainClazz() {
        if (this.domainClazz == null) {
            this.domainClazz = (Class)this.getTypeArray()[2];
        }
        return this.domainClazz;
    }

    @GetMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public Result<PageData<T>> page(Query query, PageParam pageParam) {
        BaseDomain domain = (BaseDomain)BeanUtils.copy(query, this.domainClazz);
        domain.setPageParam(pageParam);
        PageData<BaseDomain> page = this.getService().page((BaseDomain)domain);
        return Results.success(page);
    }

    @GetMapping(value={"list"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2\uff0c\u8fd4\u56deList")
    public Result<List<T>> list(Query query, PageParam pageParam) {
        BaseDomain domain = (BaseDomain)BeanUtils.copy(query, this.domainClazz);
        domain.setPageParam(pageParam);
        List<BaseDomain> list = this.getService().list((BaseDomain)domain);
        return Results.success(list);
    }

    @GetMapping(value={"/info"})
    @ApiOperation(value="\u8be6\u60c5")
    public Result<T> info(@RequestParam Long id) {
        Object domain = this.getService().getById(id);
        return Results.success(domain);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0")
    public Result<T> add(@RequestBody Form form) {
        BaseDomain domain = (BaseDomain)BeanUtils.copy(form, this.domainClazz);
        boolean canAdd = this.onAdd(domain);
        if (!canAdd) {
            return Results.forbidden();
        }
        return Results.success((Object)this.getService().add((BaseDomain)domain));
    }

    protected boolean onAdd(T domain) {
        return false;
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u7f16\u8f91")
    public Result<T> edit(@RequestBody Form form) {
        BaseDomain domain = (BaseDomain)BeanUtils.copy(form, this.domainClazz);
        boolean canEdit = this.onEdit(domain);
        if (!canEdit) {
            return Results.forbidden();
        }
        return Results.success((Object)this.getService().edit((BaseDomain)domain));
    }

    protected boolean onEdit(T domain) {
        return false;
    }
}

