package cn.tuia.mango.context.util.crypto;

import org.apache.commons.codec.binary.Base64;

import java.security.MessageDigest;

/**
 * @author lijicong
 * @since 2020-07-27
 */
public abstract class DigestKit {

    public static String sha(String str) {
        return messageDigest(str, "SHA");
    }


    public static String md5(String str) {
        return messageDigest(str, "MD5");
    }

    private static String messageDigest(String str, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(str.getBytes("UTF-8"));
            Base64 bs = new Base64();
            return bs.encodeToString(md.digest());
        } catch (Exception e) {
            // ignore
        }
        return null;
    }
}
