/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.context.web.controller;

import cn.tuia.mango.context.service.BaseMybatisInternalService;
import cn.tuia.mango.core.domain.BaseDomain;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import cn.tuia.mango.core.domain.page.PageParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public class BaseController<T extends BaseDomain, S extends BaseMybatisInternalService<?, T>> {
    protected S service;

    @Autowired
    public void setService(S service) {
        this.service = service;
    }

    public S getService() {
        return this.service;
    }

    @GetMapping(value={"page"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    public Result<PageData<T>> page(T query, PageParam pageParam) {
        query.setPageParam(pageParam);
        PageData<T> page = this.getService().page(query);
        return Results.success(page);
    }

    @GetMapping(value={"list"})
    @ApiOperation(value="\u5217\u8868\u67e5\u8be2\uff0c\u8fd4\u56deList")
    public Result<List<T>> list(T query, PageParam pageParam) {
        query.setPageParam(pageParam);
        List<T> list = this.getService().list(query);
        return Results.success(list);
    }

    @GetMapping(value={"/info"})
    @ApiOperation(value="\u8be6\u60c5")
    public Result<T> info(@RequestParam Long id) {
        Object domain = this.getService().getById(id);
        return Results.success(domain);
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u6dfb\u52a0")
    public Result<T> add(@RequestBody T domain) {
        boolean canAdd = this.onAdd(domain);
        if (!canAdd) {
            return Results.forbidden();
        }
        return Results.success(this.getService().add(domain));
    }

    protected boolean onAdd(T domain) {
        return false;
    }

    @PostMapping(value={"/edit"})
    @ApiOperation(value="\u7f16\u8f91")
    public Result<T> edit(@RequestBody T domain) {
        boolean canEdit = this.onEdit(domain);
        if (!canEdit) {
            return Results.forbidden();
        }
        return Results.success(this.getService().edit(domain));
    }

    protected boolean onEdit(T domain) {
        return false;
    }
}

