/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;

public class FreeMarkerUtils {
    private static final Version INCOMPATIBLE_IMPROVEMENTS = new Version(2, 3, 23);
    private static ThreadLocal<Configuration> threadLocal = new ThreadLocal();

    public static void remove() {
        threadLocal.remove();
    }

    public static Configuration initConfig(String templatePath, String encoding) {
        Configuration config = threadLocal.get();
        if (!templatePath.startsWith("/")) {
            templatePath = "/" + templatePath;
        }
        if (null != config) {
            config.setOutputEncoding(encoding);
            config.setEncoding(Locale.CHINA, encoding);
            config.setClassForTemplateLoading(FreeMarkerUtils.class, templatePath);
            return config;
        }
        if (null == templatePath || templatePath.trim().length() == 0) {
            throw new RuntimeException("The template path must be provided.");
        }
        config = new Configuration(INCOMPATIBLE_IMPROVEMENTS);
        config.setOutputEncoding(encoding);
        config.setEncoding(Locale.CHINA, encoding);
        config.setClassForTemplateLoading(FreeMarkerUtils.class, templatePath);
        config.setDateTimeFormat("yyyy-MM-dd HH:mm:ss");
        config.setDateFormat("yyyy-MM-dd");
        config.setTimeFormat("HH:mm:ss");
        threadLocal.set(config);
        return config;
    }

    public static Configuration initConfig(Object context, Locale locale, String encoding, String templatePath) {
        Configuration config = threadLocal.get();
        if (null != config) {
            return config;
        }
        if (null == templatePath || templatePath.trim().length() == 0) {
            throw new RuntimeException("The template path must be provided.");
        }
        if (!templatePath.startsWith("/")) {
            templatePath = "/" + templatePath;
        }
        config = new Configuration(INCOMPATIBLE_IMPROVEMENTS);
        config.setOutputEncoding(encoding);
        config.setEncoding(locale, encoding);
        config.setClassForTemplateLoading(FreeMarkerUtils.class, templatePath);
        threadLocal.set(config);
        return config;
    }

    public static Configuration initConfig(String templatePath) {
        return FreeMarkerUtils.initConfig(templatePath, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String template(String templatePath, String templateName, Map<String, Object> dataMap) {
        Configuration config = FreeMarkerUtils.initConfig(templatePath);
        Template template = null;
        StringWriter writer = new StringWriter();
        try {
            template = config.getTemplate(templateName);
            template.process(dataMap, (Writer)writer);
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
        }
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void template(String templatePath, String templateName, Map<String, Object> dataMap, OutputStream os, String encoding) {
        Configuration config = FreeMarkerUtils.initConfig(templatePath);
        Template template = null;
        Writer writer = null;
        try {
            template = config.getTemplate(templateName);
            writer = new OutputStreamWriter(os, encoding);
            template.process(dataMap, writer);
            writer.close();
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void template(String templatePath, String templateName, Map<String, Object> dataMap, OutputStream os) {
        FreeMarkerUtils.template(templatePath, templateName, dataMap, os, "UTF-8");
    }
}

