/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.internal.DefaultShellCallback;

public class TemplateGenerator {
    protected ShellCallback shellCallback = new DefaultShellCallback(false);
    protected List<GeneratedFile> generatedFiles = new ArrayList<GeneratedFile>();

    private TemplateGenerator() {
    }

    public static TemplateGenerator getInstance() {
        return InstanceHolder.instance;
    }

    public void generate() {
        for (GeneratedFile generatedFile : this.generatedFiles) {
            this.writeGeneratedFile(generatedFile);
        }
    }

    protected void writeGeneratedFile(GeneratedFile generatedFile) {
        try {
            File project = new File(generatedFile.getTargetProject());
            if (!project.isDirectory()) {
                project.mkdirs();
            }
            File directory = this.shellCallback.getDirectory(generatedFile.getTargetProject(), generatedFile.getTargetPackage());
            File targetFile = new File(directory, generatedFile.getFileName());
            String source = generatedFile.getFormattedContent();
            this.writeFile(targetFile, source, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void writeFile(File file, String content, String fileEncoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, false);
        OutputStreamWriter osw = fileEncoding == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, fileEncoding);
        BufferedWriter bw = new BufferedWriter(osw);
        bw.write(content);
        bw.close();
    }

    public ShellCallback getShellCallback() {
        return this.shellCallback;
    }

    public List<GeneratedFile> getGeneratedFiles() {
        return this.generatedFiles;
    }

    public void addGeneratedFile(GeneratedFile generatedFile) {
        if (generatedFile != null) {
            this.generatedFiles.add(generatedFile);
        }
    }

    private static class InstanceHolder {
        private static final TemplateGenerator instance = new TemplateGenerator();

        private InstanceHolder() {
        }
    }
}

