package cn.tuia.mango.generator.mybatis.api;

import cn.tuia.mango.generator.mybatis.codegen.ExtensionConstants;
import cn.tuia.mango.generator.mybatis.util.StringUtils;
import lombok.Getter;
import lombok.Setter;
import org.mybatis.generator.api.GeneratedFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.StringUtility;

import java.util.Properties;

@Setter
@Getter
public class GeneratedTemplateFile extends GeneratedFile {

    protected String targetPackage;
    protected String formattedContent;
    protected String fileName;

    protected String fileNameFormat;

    protected Context context;
    protected Properties properties;
    protected IntrospectedTable table;

    public GeneratedTemplateFile(String targetProject) {
        super(targetProject);
    }

    public GeneratedTemplateFile(String targetProject, String targetPackage, Context context, Properties properties, IntrospectedTable table) {
        this(targetProject, targetPackage, context, properties, table, null);
    }

    public GeneratedTemplateFile(String targetProject, String targetPackage, Context context, Properties properties, IntrospectedTable table, String fileNameFormat) {
        super(targetProject);
        this.targetPackage = targetPackage;
        this.context = context;
        this.properties = properties;
        this.table = table;
        this.fileNameFormat = fileNameFormat;
        init();
    }

    private void init() {
        Object className = table.getAttribute(ExtensionConstants.ORIGINAL_CLASS_NAME);
        Object templateName = table.getAttribute("templateName");
        if (StringUtility.stringHasValue(fileNameFormat)) {
            this.fileName = String.format(fileNameFormat, className);
        } else {
            this.fileName = className.toString() + templateName.toString();
        }
    }

    @Override
    public String getFormattedContent() {
        return formattedContent;
    }

    @Override
    public String getFileName() {
        return fileName;
    }

    @Override
    public String getTargetPackage() {
        return targetPackage;
    }

    @Override
    public boolean isMergeable() {
        return false;
    }

}
