<template>
  <el-dialog :append-to-body="true" :close-on-click-modal="false" :before-close="handleCancel" :visible.sync="dialog" :title="isAdd ? '新增' : '编辑'" class="x-orange-dialog">
    <el-form ref="form" :model="data" :rules="rules" :inline="true" size="small">
  <#list table.allColumns as field><#if field_index == 0>    <#else>      </#if><el-form-item label="${field.remarks}" prop="${field.javaProperty}">
          <@formField field=field/>
      </el-form-item>
  </#list>
    </el-form>
    <div slot="footer" class="dialog-footer">
      <el-button type="text" @click="handleCancel">取消</el-button>
      <el-button :loading="loading" type="primary" @click="handleSubmit">确认</el-button>
    </div>
  </el-dialog>
</template>

<script>
import { addApi, editApi } from '@/api/${originalClassName?uncap_first}}'
export default {
  props: {
    isAdd: {
      type: Boolean,
      required: true
    }
  },
  data() {
    return {
      loading: false,
      dialog: false,
      data: {
    <#list table.allColumns as field>
        ${field.javaProperty}: ''<#if field_has_next>,</#if>
    </#list>
      },
      rules: {
<#list table.allColumns as field>
  <#if field_index lt 2>
        ${field.javaProperty}: [
          { required: true, message: '请输入${field.remarks}', trigger: 'blur' }
        ]<#if (field_has_next && field_index lt 1)>,</#if>
  </#if>
</#list>
      }
    }
  },
  methods: {
    handleCancel() {
      this.resetForm()
    },
    handleSubmit() {
      this.$refs['form'].validate((valid) => {
        if (!valid) return false
        this.loading = true
        if (this.isAdd) {
          this.doAdd()
        } else {
          this.doEdit()
        }
      })
    },
    doAdd() {
      addApi(this.data).then(res => {
        this.$notify({ title: '添加成功', type: 'success', duration: 2500 })
        this.loading = this.dialog = false
        this.resetForm()
        this.$parent.init()
      }).catch(err => {
        this.loading = false
        console.log(err.response.data.message)
      })
    },
    doEdit() {
      editApi(this.data).then(res => {
        this.$notify({ title: '修改成功', type: 'success', duration: 2500 })
        this.loading = this.dialog = false
        this.resetForm()
        this.$parent.init()
      }).catch(err => {
        this.loading = false
        console.log(err.response.data.message)
      })
    },
    resetForm() {
      this.dialog = false
      this.$refs['form'].resetFields()
      const data = {}
      this.data = Object.assign(data, this.data)
    }
  }
}
</script>

<style scoped>

</style>

<#macro formField field>
  <#switch field.fullyQualifiedJavaType.shortName>
    <#case "String">
        <el-input v-model="data.${field.javaProperty}"/>
      <#break>
    <#case "Byte">
    <#case "Short">
    <#case "Integer">
    <#case "Long">
        <el-input v-model="data.${field.javaProperty}"/>
      <#break>
    <#case "Date">
        <el-date-picker v-model="data.${field.javaProperty}" type="datetime"/>
      <#break>
    <#default>
        <el-input v-model="data.${field.javaProperty}"/>
      <#break>
  </#switch>
</#macro>