/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.codegen.mybatis3.model;

import cn.tuia.mango.generator.mybatis.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mybatis.generator.api.IntrospectedColumn;

public class JavaEnumConfig {
    private String serviceTargetPackage;
    private String targetPackage;
    private String targetProject;
    private String module;
    private String enumPackage;
    private boolean enableEnum;
    private Map<String, IntrospectedColumn> columnCommentMap = new HashMap<String, IntrospectedColumn>();
    private List<EnumConfig> enums;

    public IntrospectedColumn putIfAbsent(String key, IntrospectedColumn value) {
        return this.columnCommentMap.putIfAbsent(key, value);
    }

    public void init() {
        if (this.serviceTargetPackage == null) {
            return;
        }
        String[] packages = this.serviceTargetPackage.split("\\.");
        this.module = packages[packages.length - 1];
        this.enums = new ArrayList<EnumConfig>();
        for (Map.Entry<String, IntrospectedColumn> entry : this.columnCommentMap.entrySet()) {
            IntrospectedColumn column = entry.getValue();
            String remarks = column.getRemarks();
            EnumConfig enumConfig = new EnumConfig();
            enumConfig.setClassName(StringUtils.capitalize(entry.getKey()) + "Enum");
            enumConfig.setRemarks(remarks);
            enumConfig.setJavaType(column.getFullyQualifiedJavaType().getShortName());
            try {
                String[] s = remarks.split(" ");
                ArrayList<EnumItemConfig> itemList = new ArrayList<EnumItemConfig>();
                for (int i = 1; i < s.length; ++i) {
                    String[] item = s[i].split(":");
                    EnumItemConfig itemConfig = new EnumItemConfig();
                    itemConfig.setText(column.getActualColumnName().toUpperCase() + "_" + item[0]);
                    itemConfig.setCode(item[0]);
                    itemConfig.setDesc(item[1]);
                    itemList.add(itemConfig);
                }
                enumConfig.setItemList(itemList);
                this.enums.add(enumConfig);
            }
            catch (Exception e) {
                System.err.println("\u8868[" + column.getIntrospectedTable().getFullyQualifiedTableNameAtRuntime() + "], \u5b57\u6bb5[" + column.getActualColumnName() + "], \u6ce8\u91ca[" + column.getRemarks() + "], \u4e0d\u7b26\u5408\u89c4\u8303[remark code1:value1 code2:value2], \u4e0d\u80fd\u751f\u6210\u679a\u4e3e");
            }
        }
    }

    public String getServiceTargetPackage() {
        return this.serviceTargetPackage;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getTargetProject() {
        return this.targetProject;
    }

    public String getModule() {
        return this.module;
    }

    public String getEnumPackage() {
        return this.enumPackage;
    }

    public boolean isEnableEnum() {
        return this.enableEnum;
    }

    public Map<String, IntrospectedColumn> getColumnCommentMap() {
        return this.columnCommentMap;
    }

    public List<EnumConfig> getEnums() {
        return this.enums;
    }

    public void setServiceTargetPackage(String serviceTargetPackage) {
        this.serviceTargetPackage = serviceTargetPackage;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setTargetProject(String targetProject) {
        this.targetProject = targetProject;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setEnumPackage(String enumPackage) {
        this.enumPackage = enumPackage;
    }

    public void setEnableEnum(boolean enableEnum) {
        this.enableEnum = enableEnum;
    }

    public void setColumnCommentMap(Map<String, IntrospectedColumn> columnCommentMap) {
        this.columnCommentMap = columnCommentMap;
    }

    public void setEnums(List<EnumConfig> enums) {
        this.enums = enums;
    }

    public static class EnumItemConfig {
        private String text;
        private String code;
        private String desc;

        public void setText(String text) {
            this.text = text;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getText() {
            return this.text;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static class EnumConfig {
        private String className;
        private String remarks;
        private String javaType;
        private List<EnumItemConfig> itemList;

        public void setClassName(String className) {
            this.className = className;
        }

        public void setRemarks(String remarks) {
            this.remarks = remarks;
        }

        public void setJavaType(String javaType) {
            this.javaType = javaType;
        }

        public void setItemList(List<EnumItemConfig> itemList) {
            this.itemList = itemList;
        }

        public String getClassName() {
            return this.className;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public List<EnumItemConfig> getItemList() {
            return this.itemList;
        }
    }
}

