/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.internal.types;

import java.util.Properties;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.mybatis.generator.internal.util.StringUtility;

public class JavaTypeResolver
extends JavaTypeResolverDefaultImpl {
    private boolean tinyInt1isBit;
    private boolean isPrefixTinyIntisBit;

    public JavaTypeResolver() {
        this.typeMap.put(5, new JavaTypeResolverDefaultImpl.JdbcTypeInformation("SMALLINT", new FullyQualifiedJavaType(Integer.class.getName())));
        this.typeMap.put(-6, new JavaTypeResolverDefaultImpl.JdbcTypeInformation("TINYINT", new FullyQualifiedJavaType(Integer.class.getName())));
    }

    public void addConfigurationProperties(Properties properties) {
        super.addConfigurationProperties(properties);
        this.tinyInt1isBit = StringUtility.isTrue((String)properties.getProperty("tinyInt1isBit"));
        this.isPrefixTinyIntisBit = StringUtility.isTrue((String)properties.getProperty("isPrefixTinyIntisBit"));
    }

    protected FullyQualifiedJavaType overrideDefaultType(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        FullyQualifiedJavaType answer = super.overrideDefaultType(column, defaultType);
        switch (column.getJdbcType()) {
            case -6: {
                answer = this.calculateTinyIntReplacement(column, defaultType);
            }
        }
        return answer;
    }

    protected FullyQualifiedJavaType calculateTinyIntReplacement(IntrospectedColumn column, FullyQualifiedJavaType defaultType) {
        FullyQualifiedJavaType answer = defaultType;
        if (column.getLength() == 1 && this.tinyInt1isBit) {
            answer = new FullyQualifiedJavaType(Boolean.class.getName());
        }
        if (this.isPrefixTinyIntisBit && column.getJavaProperty().startsWith("is")) {
            answer = new FullyQualifiedJavaType(Boolean.class.getName());
        }
        return answer;
    }
}

