/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.generator.mybatis.util;

import cn.tuia.mango.generator.mybatis.util.FreeMarkerUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.generator.internal.util.JavaBeansUtil;

public class TableElementsUtils {
    public static final String TEMPLATE_PATH = "template/";

    public static void print(String tables, String preffix) {
        List list = Arrays.stream(tables.split(",")).map(item -> {
            String tableName = item.trim();
            String simpeTable = tableName.replace("tb_", "");
            String className = JavaBeansUtil.getCamelCaseString((String)simpeTable, (boolean)true);
            return new Table(tableName, className);
        }).collect(Collectors.toList());
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("list", list);
        String content = FreeMarkerUtils.template(TEMPLATE_PATH, "table.element.ftl", dataMap);
        System.out.println(content);
    }

    public static void main(String[] args) {
        String tables = "tb_table1, tb_table2, tb_table3";
        TableElementsUtils.print(tables, "tb_");
    }

    public static class Table {
        private String tableName;
        private String className;

        public String getTableName() {
            return this.tableName;
        }

        public String getClassName() {
            return this.className;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Table(String tableName, String className) {
            this.tableName = tableName;
            this.className = className;
        }
    }
}

