package cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements;

import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.codegen.mybatis3.xmlmapper.elements.AbstractXmlElementGenerator;

/**
 * @author lijicong
 * @since 2020-03-23
 */
public abstract class AbstractWhereConditionElementGenerator extends AbstractXmlElementGenerator {

    public static final String SQL_CONDITION_ID = "condition";

    protected void addWhereElement(XmlElement answer) {
        XmlElement whereElement = new XmlElement("where");
        answer.addElement(whereElement);
        addIsNotNullElement(whereElement);
    }

    protected void addWhereConditionElement(XmlElement answer) {
        XmlElement whereElement = new XmlElement("where");
        answer.addElement(whereElement);
        XmlElement includeElement = new XmlElement("include");
        includeElement.addAttribute(new Attribute("refid", SQL_CONDITION_ID));
        whereElement.addElement(includeElement);
    }

    protected void addSqlConditionElement(XmlElement answer) {
        XmlElement sqlElement = new XmlElement("sql");
        answer.addElement(sqlElement);

        sqlElement.addAttribute(new Attribute("id", SQL_CONDITION_ID));
        addIsNotNullElement(sqlElement);
    }

    protected void addIsNotNullElement(XmlElement xmlElement) {
        for (IntrospectedColumn introspectedColumn : ListUtilities.removeGeneratedAlwaysColumns(introspectedTable.getAllColumns())) {
            if (!introspectedColumn.isBLOBColumn()) {
                XmlElement isNotNullElement = new XmlElement("if"); //$NON-NLS-1$
                StringBuilder sb = new StringBuilder();
                sb.append(introspectedColumn.getJavaProperty());
                sb.append(" != null");
                if ("String".equals(introspectedColumn.getFullyQualifiedJavaType().getShortName())) {
                    sb.append(" and ");
                    sb.append(introspectedColumn.getJavaProperty());
                    sb.append(" != ''");
                }
                isNotNullElement.addAttribute(new Attribute("test", sb.toString())); //$NON-NLS-1$

                sb.setLength(0);
                sb.append(" and ");
                sb.append(MyBatis3FormattingUtilities.getEscapedColumnName(introspectedColumn));
                sb.append(" = ");
                sb.append(MyBatis3FormattingUtilities.getParameterClause(introspectedColumn));

                isNotNullElement.addElement(new TextElement(sb.toString()));

                xmlElement.addElement(isNotNullElement);
            }
        }
    }


}
