package cn.tuia.mango.generator.mybatis.plugin;

import cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.GeneratorUtil;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements.InsertBatchElementGenerator;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements.SelectCountElementGenerator;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements.SelectListElementGenerator;
import cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements.SqlConditionElementGenerator;
import cn.tuia.mango.generator.mybatis.config.PropertyRegistryExtension;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.config.PropertyRegistry;
import org.mybatis.generator.internal.util.StringUtility;

import java.util.List;

/**
 * 修改mybatis-generator默认生成的类
 * @author lijicong
 * @since 2020-03-19
 */
public class ModifyMybatisInternalPlugin extends PluginAdapter {

    public static FullyQualifiedJavaType ANNOTATION_LOMBOK_DATA = new FullyQualifiedJavaType("lombok.Data");
    public static FullyQualifiedJavaType ANNOTATION_LOMBOK_SETTER = new FullyQualifiedJavaType("lombok.Getter");
    public static FullyQualifiedJavaType ANNOTATION_LOMBOK_GETTER = new FullyQualifiedJavaType("lombok.Setter");

    public static FullyQualifiedJavaType ANNOTATION_LOMBOK_ALLARGSCONSTRUCTOR = new FullyQualifiedJavaType("lombok.AllArgsConstructor");
    public static FullyQualifiedJavaType ANNOTATION_LOMBOK_BUILDER = new FullyQualifiedJavaType("lombok.Builder");
    public static FullyQualifiedJavaType ANNOTATION_LOMBOK_NOARGSCONSTRUCTOR = new FullyQualifiedJavaType("lombok.NoArgsConstructor");

    // protected FullyQualifiedJavaType modelBaseRecordClass;
    protected boolean enableLombokBuilder;

    @Override
    public boolean validate(List<String> warnings) {
        if (StringUtility.isTrue(context.getProperty(PropertyRegistryExtension.PLUGIN_ENABLE_LOMBOK_BUILDER))) {
            enableLombokBuilder = true;
        }
        return true;
    }

    @Override
    public boolean modelBaseRecordClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        String rootClass = context.getJavaModelGeneratorConfiguration().getProperty(PropertyRegistry.ANY_ROOT_CLASS);
        //if (!topLevelClass.getImportedTypes().contains(ANNOTATION_LOMBOK_DATA)) {
        //    topLevelClass.addImportedType(ANNOTATION_LOMBOK_DATA);
        //}
        if (!topLevelClass.getImportedTypes().contains(ANNOTATION_LOMBOK_SETTER)) {
            topLevelClass.addImportedType(ANNOTATION_LOMBOK_SETTER);
        }
        if (!topLevelClass.getImportedTypes().contains(ANNOTATION_LOMBOK_GETTER)) {
            topLevelClass.addImportedType(ANNOTATION_LOMBOK_GETTER);
        }
        //topLevelClass.addAnnotation("@Data");
        topLevelClass.addAnnotation("@Getter");
        topLevelClass.addAnnotation("@Setter");

        if (enableLombokBuilder || StringUtility.isTrue(introspectedTable.getTableConfiguration().getProperty(PropertyRegistryExtension.PLUGIN_ENABLE_LOMBOK_BUILDER))) {
            if (!topLevelClass.getImportedTypes().contains(ANNOTATION_LOMBOK_ALLARGSCONSTRUCTOR)) {
                topLevelClass.addImportedType(ANNOTATION_LOMBOK_ALLARGSCONSTRUCTOR);
            }
            if (!topLevelClass.getImportedTypes().contains(ANNOTATION_LOMBOK_BUILDER)) {
                topLevelClass.addImportedType(ANNOTATION_LOMBOK_BUILDER);
            }
            if (!topLevelClass.getImportedTypes().contains(ANNOTATION_LOMBOK_NOARGSCONSTRUCTOR)) {
                topLevelClass.addImportedType(ANNOTATION_LOMBOK_NOARGSCONSTRUCTOR);
            }
            topLevelClass.addAnnotation("@Builder");
            topLevelClass.addAnnotation("@NoArgsConstructor");
            topLevelClass.addAnnotation("@AllArgsConstructor");
        }


        if (StringUtility.stringHasValue(rootClass)) {
            topLevelClass.addAnnotation("@SuppressWarnings(\"serial\")");
        }
        // modelBaseRecordClass = topLevelClass.getType();
        return true;
    }

    @Override
    public boolean modelGetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        return false;
    }

    @Override
    public boolean modelSetterMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedColumn introspectedColumn, IntrospectedTable introspectedTable, ModelClassType modelClassType) {
        return introspectedColumn.getFullyQualifiedJavaType().getShortNameWithoutTypeArguments().equals("String");
    }

    @Override
    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean clientDeleteByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean clientGenerated(Interface interfaze, TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        /*Set<FullyQualifiedJavaType> superInterfaceTypes = interfaze.getSuperInterfaceTypes();
        if (CollectionUtils.isNotEmpty(superInterfaceTypes)) {
            for (FullyQualifiedJavaType superInterfaceType : superInterfaceTypes) {
                FullyQualifiedJavaType fullyQualifiedJavaType = modelBaseRecordClass;
                if (!interfaze.getImportedTypes().contains(fullyQualifiedJavaType)) {
                    interfaze.addImportedType(fullyQualifiedJavaType);
                }
                // TODO
                // superInterfaceType.addTypeArgument(new FullyQualifiedJavaType(modelBaseRecordClass.getShortName()));
            }
        }*/
        return false;
    }

    // 内置方法不生成
    @Override
    public boolean clientInsertMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean clientInsertSelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean clientSelectByPrimaryKeyMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean clientUpdateByPrimaryKeySelectiveMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean clientUpdateByPrimaryKeyWithoutBLOBsMethodGenerated(Method method, Interface interfaze, IntrospectedTable introspectedTable) {
        return false;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        GeneratorUtil.addElements(context, introspectedTable, document, new SqlConditionElementGenerator());
        GeneratorUtil.addElements(context, introspectedTable, document, new SelectListElementGenerator());
        GeneratorUtil.addElements(context, introspectedTable, document, new SelectCountElementGenerator());
        GeneratorUtil.addElements(context, introspectedTable, document, new InsertBatchElementGenerator());
        return true;
    }
}
