package cn.tuia.mango.generator.mybatis.api;

import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

import java.util.List;

/**
 * @author lijicong
 * @since 2020-05-20
 */
public class AntGeneratorProgressCallback extends GeneratorProcessCallback {

    /** The task. */
    private Task task;

    /** The verbose. */
    private boolean verbose;

    /**
     * Instantiates a new ant progress callback.
     * @param task the task
     * @param verbose the verbose
     */
    public AntGeneratorProgressCallback(Task task, boolean verbose, List<String> warnings) {
        super(warnings);
        this.task = task;
        this.verbose = verbose;
        this.warnings = warnings;
    }

    /* (non-Javadoc)
     * @see org.mybatis.generator.internal.NullProgressCallback#startTask(java.lang.String)
     */
    @Override
    public void startTask(String subTaskName) {
        if (verbose) {
            task.log(subTaskName, Project.MSG_VERBOSE);
        }
    }
}
