package cn.tuia.mango.generator.mybatis.codegen.mybatis3.xmlmapper.elements;

import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

/**
 * @author lijicong
 * @since 2020-03-23
 */
public class SelectListElementGenerator extends AbstractWhereConditionElementGenerator {

    @Override
    public void addElements(XmlElement parentElement) {
        XmlElement answer = new XmlElement("select");
        answer.addAttribute(new Attribute("id", "selectList"));
        // if (introspectedTable.getRules().generateResultMapWithBLOBs()) {
        //     answer.addAttribute(new Attribute("resultMap", introspectedTable.getResultMapWithBLOBsId()));
        // } else {
        answer.addAttribute(new Attribute("resultMap", introspectedTable.getBaseResultMapId()));
        // }

        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
        answer.addAttribute(new Attribute("parameterType", parameterType.getFullyQualifiedName()));

        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        answer.addElement(new TextElement(sb.toString()));
        answer.addElement(getBaseColumnListElement());
        sb.setLength(0);
        sb.append("from ");
        sb.append(introspectedTable.getAliasedFullyQualifiedTableNameAtRuntime());
        answer.addElement(new TextElement(sb.toString()));

        addWhereConditionElement(answer);

        XmlElement orderByElement = new XmlElement("if");
        sb.setLength(0);
        sb.append("pageParam != null and pageParam.sort != null and pageParam.sort != '' and pageParam.order != null and pageParam.order != ''");
        orderByElement.addAttribute(new Attribute("test", sb.toString())); //$NON-NLS-1$
        answer.addElement(orderByElement);

        sb.setLength(0);
        sb.append("order by ${pageParam.sort} ${pageParam.order}");
        orderByElement.addElement(new TextElement(sb.toString()));

        XmlElement isNotNullElement = new XmlElement("if");
        sb.setLength(0);
        sb.append("pageParam != null");
        isNotNullElement.addAttribute(new Attribute("test", sb.toString())); //$NON-NLS-1$
        answer.addElement(isNotNullElement);

        sb.setLength(0);
        sb.append("limit #{pageParam.offset}, #{pageParam.size}");
        isNotNullElement.addElement(new TextElement(sb.toString()));

        parentElement.addElement(answer);
    }

}
