import request from '@/utils/request'

export function pageApi(params) {
  return request({
    url: '${cfg.StringHelper.path(cfg.gc, table)}',
    method: 'get',
    params
  })
}

export function addApi(data) {
  return request({
    url: '${cfg.StringHelper.path(cfg.gc, table)}',
    method: 'post',
    data
  })
}

export function editApi(data) {
  return request({
    url: '${cfg.StringHelper.path(cfg.gc, table)}',
    method: 'put',
    data
  })
}

export function infoApi(id) {
  return request({
    url: '${cfg.StringHelper.path(cfg.gc, table)}/' + id,
    method: 'get'
  })
}

export function deleteApi(id) {
  return request({
    url: '${cfg.StringHelper.path(cfg.gc, table)}/' + id,
    method: 'delete'
  })
}

