package cn.tuia.mango.generator.mybatis.plugin;

import cn.tuia.mango.generator.mybatis.api.GeneratedTemplateFile;
import org.mybatis.generator.api.IntrospectedTable;

/**
 * @author lijicong
 * @since 2021-09-10
 */
public class JavaScriptPlugin extends AbstractTemplatePlugin {

    protected String viewsTargetPackage;

    @Override
    public void initialized(IntrospectedTable introspectedTable) {
        // vue.api.js
        registerConfigMap("Api.js", introspectedTable);

        // vue.form.vue
        introspectedTable.setAttribute("templateName", "Form.vue");
        GeneratedTemplateFile formConfig = new GeneratedTemplateFile(targetProject, viewsTargetPackage, context, properties, introspectedTable);
        configMap.put("Form.vue", formConfig);

        // vue.index.vue
        introspectedTable.setAttribute("templateName", "Index.vue");
        GeneratedTemplateFile indexConfig = new GeneratedTemplateFile(targetProject, viewsTargetPackage, context, properties, introspectedTable);
        configMap.put("Index.vue", indexConfig);

        templateGenerate();
    }
}
