import request from '@/utils/request'

export function pageApi(params) {
  return request({
    url: 'api/${originalClassName?uncap_first}/page',
    method: 'get',
    params
  })
}

export function addApi(data) {
  return request({
    url: 'api/${originalClassName?uncap_first}/add',
    method: 'post',
    data
  })
}

export function editApi(data) {
  return request({
    url: 'api/${originalClassName?uncap_first}/edit',
    method: 'put',
    data
  })
}

export function infoApi(id) {
  return request({
    url: 'api/${originalClassName?uncap_first}/info?id=' + id,
    method: 'get'
  })
}

