<#import "common.lib.java.ftl" as java>
package ${config.targetPackage};

import ${config.context.javaModelGeneratorConfiguration.targetPackage}.${originalClassName}DO;
import ${config.properties.targetPackage}.${originalClassName}Service;
import cn.tuia.mango.core.domain.api.Result;
import cn.tuia.mango.core.domain.api.Results;
import cn.tuia.mango.core.domain.page.PageData;
import cn.tuia.mango.core.domain.page.PageParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

<@java.javaClassDoc table=config.table suffix=" Controller"/>
@RestController()
@RequestMapping("${config.properties.requestMappingPrefix}${originalClassName?uncap_first}")
@Api(tags = "<@java.tableRemarks table=config.table/>")
public class ${originalClassName}Controller {

    @Resource
    protected ${originalClassName}Service ${originalClassName?uncap_first}Service;

    @GetMapping("page")
    @ApiOperation("分页查询")
    public Result<PageData<${originalClassName}DO>> page(${originalClassName}DO query, PageParam pageParam) {
        query.setPageParam(pageParam);
        return Results.success(${originalClassName?uncap_first}Service.page(query));
    }

    @GetMapping("list")
    @ApiOperation("列表查询，返回List")
    public Result<List<${originalClassName}DO>> list(${originalClassName}DO query, PageParam pageParam) {
        query.setPageParam(pageParam);
        return Results.success(${originalClassName?uncap_first}Service.list(query));
    }

    @GetMapping("/info")
    @ApiOperation("详情")
    public Result<${originalClassName}DO> info(Long id) {
        return Results.success(${originalClassName?uncap_first}Service.getById(id));
    }

    @PostMapping("/add")
    @ApiOperation("添加")
    public Result<${originalClassName}DO> add(@RequestBody ${originalClassName}DO domain) {
    return Results.success(${originalClassName?uncap_first}Service.add(domain));
    }

    @PostMapping("/edit")
    @ApiOperation("编辑")
    public Result<${originalClassName}DO> edit(@RequestBody ${originalClassName}DO domain) {
        return Results.success(${originalClassName?uncap_first}Service.edit(domain));
    }

}