/*
 * Decompiled with CFR 0.152.
 */
package cn.tuia.mango.sso.service;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.RoleDto;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.service.power.PowerCache;
import cn.com.duiba.sso.api.service.power.PowerTreeCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.tuia.mango.core.domain.tree.TreeBuilder;
import cn.tuia.mango.sso.model.AuthInfoVO;
import cn.tuia.mango.sso.model.UserVO;
import cn.tuia.mango.sso.model.VueMenuVO;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SsoAuthExtService {
    private static final Logger log = LoggerFactory.getLogger(SsoAuthExtService.class);
    @Resource
    private RemotePermissionService remotePermissionService;
    @Resource
    private AdminPowerCacheService adminPowerCacheService;
    @Resource
    private PowerTreeService powerTreeService;

    public AuthInfoVO getCurrentAuthInfo() {
        AuthInfoVO authInfoVO = new AuthInfoVO();
        List roleDtos = this.remotePermissionService.getAdminAllRoles(SystemInfo.getThisSystemId(), RequestTool.getAdminId());
        if (CollectionUtils.isNotEmpty((Collection)roleDtos)) {
            List<String> roles = roleDtos.stream().map(RoleDto::getDescription).collect(Collectors.toList());
            authInfoVO.setRoles(roles);
        }
        Set powerRes = this.adminPowerCacheService.getAllPowerRes(RequestTool.getAdminId());
        authInfoVO.setResources(new ArrayList<String>(powerRes));
        AdminDto admin = RequestTool.getAdmin();
        UserVO userVO = new UserVO();
        userVO.setAdminId(admin.getId());
        userVO.setUsername(admin.getName());
        userVO.setAccount(admin.getAccount());
        userVO.setEmail(admin.getEmail());
        authInfoVO.setUser(userVO);
        return authInfoVO;
    }

    public List<VueMenuVO> listVueMenu() {
        PowerCache powerCache = this.getPowerCache();
        if (powerCache == null) {
            return Collections.emptyList();
        }
        PowerTreeCache powerTreeCache = this.powerTreeService.getPowerTreeCache(SystemInfo.getThisSystemId());
        List treeView = powerTreeCache.getPowerTree().getTreeView();
        List menus = treeView.stream().filter(item -> powerCache.getPowerIdSet().contains(item.getId()) && StringUtils.isNotBlank((CharSequence)item.getJson())).map(item -> {
            VueMenuVO menu = new VueMenuVO();
            menu.setId(item.getId());
            menu.setParentId(item.getParentId());
            menu.setName(item.getName());
            if (CollectionUtils.isNotEmpty((Collection)item.getUrls())) {
                menu.setPath((String)new ArrayList(item.getUrls()).get(0));
            }
            if (StringUtils.isNotBlank((CharSequence)item.getJson())) {
                VueMenuVO vueMenuVO = (VueMenuVO)((Object)((Object)JSON.parseObject((String)item.getJson(), VueMenuVO.class)));
                menu.setPath(vueMenuVO.getPath());
                menu.setHidden(vueMenuVO.getHidden() == null ? false : vueMenuVO.getHidden());
                menu.setRedirect(vueMenuVO.getRedirect() == null ? "noredirect" : vueMenuVO.getRedirect());
                menu.setComponent(vueMenuVO.getComponent() == null ? "Layout" : vueMenuVO.getComponent());
                menu.setAlwaysShow(vueMenuVO.getAlwaysShow() == null ? true : vueMenuVO.getAlwaysShow());
                menu.setMeta(vueMenuVO.getMeta() == null ? new VueMenuVO.MenuMetaVo("tile", "icon", true) : vueMenuVO.getMeta());
            }
            return menu;
        }).collect(Collectors.toList());
        VueMenuVO vueMenuVO = (VueMenuVO)TreeBuilder.buildTreeByParentId(menus, (Long)0L);
        VueMenuVO menuVO = vueMenuVO.getChildren().stream().filter(item -> "\u83dc\u5355".equals(item.getName())).findFirst().orElse(new VueMenuVO());
        return menuVO.getChildren();
    }

    protected PowerCache getPowerCache() {
        try {
            Object getPowerCache = MethodUtils.invokeMethod((Object)this.adminPowerCacheService, (boolean)true, (String)"getPowerCache", (Object[])new Object[]{RequestTool.getAdminId()});
            if (getPowerCache instanceof PowerCache) {
                return (PowerCache)getPowerCache;
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6sso\u6743\u9650\u5f02\u5e38", (Throwable)e);
        }
        return null;
    }
}

