
//引入框架页首页代码
BUI.use(['common/main', 'common/page']);

function topManagerTabChange(ev){
	var item = ev.item, itemId = item.get('id');
	if(/^customer\-\w+/.test(itemId)){
		top.topManager.reloadPage();
	}
}

BUI.Grid.Format.YesNo = function(data){
	var select2Data = [{ id: '0', text: '否', style: 'label label-warning'}, { id: '1', text: '是', style: 'label label-success'}, 
	                   { id: 'false', text: '否', style: 'label label-warning'}, { id: 'true', text: '是', style: 'label label-success'}
	                  ];
	data = data + '';
	if(!data) {
        return '';
    }
	var str = '';
    $.each(select2Data, function(i, item){
    	if(data == item.id){
    		str = '<span class="' + item.style + '">' + item.text + '</span>';
    		return false;
    	}
    });
	return str;
}
BUI.Grid.Format.YesNoEnum = {'true': '是', 'false': '否'};

BUI.Grid.Format.fixWidth = function (grid) {
	$(function(){
		var selector = grid.get('render'), gridEl = $(selector), parent = gridEl.parent();
		width = BUI.viewportWidth() - gridEl.offset().left - 28;
		parent.css('width', width);
		grid.set('width', width);
	});
}

BUI.gridWidth = function(gridSelector, fixWidth){
	return BUI.viewportWidth() - $(gridSelector ? gridSelector : '#grid').offset().left - (BUI.isNumber(fixWidth) ? fixWidth : 28);
}
BUI.gridHeight = function(gridSelector, fixWidth) {
	return BUI.viewportHeight() - $(gridSelector ? gridSelector : '#grid').offset().top - (BUI.isNumber(fixWidth) ? fixWidth : 36);
}
/**
 * 带有样式的枚举渲染
 * 要与$!{dict.getDictJsonMore("")}共同使用
 * @param {Object}
 */
BUI.Grid.Format.enumRendererCss = function(enumObj){
	return function (value) {
		var str = '', value = value + '';
		$.each(enumObj, function(i, item){
			if(item && item.value == value){
				var cls = item.css ? ' class="' + item.css + '"' : '';
				str += '<span' + cls + '>' + item.label + '</span>';
			}
		});
        return str;
    };
}

BUI.buildTree = function(data, cfg) {
	var cfg = BUI.merge({
		id : 'id', pId : 'parentId', children: 'children', rootId: 0, name: 'name'
	}, cfg);
	if(!data || data.length < 0) return null;
	var parents = getParents(data, cfg.rootId);
	$.each(parents, function(i, item){
		var children = [];
		item[cfg.children] = getChildren(data, item[cfg.id]);
	});
	function getParents(data, pId) {
		var parents = [];
		$.each(data, function(i, item){
			item['name'] = item['text'] = item[cfg.name];
			if(item[cfg.pId] == pId) {
				parents.push(item);
			}
		});
		return parents;
	}
	function getChildren(data, id) {
		var children = [];
		$.each(data, function(i, item){
			item['name'] = item['text'] = item[cfg.name];
			if(item[cfg.pId] == id) {
				children.push(item);
				item[cfg.children] = getChildren(data, item[cfg.id]);
			}
		});
		return children;
	}
	//console.log(parents)
	return parents;
}

BUI.Form.Rules.add({
	name : 'integer',
	msg : '不是有效的整数！',
	validator : function(value,baseValue,formatedMsg){
		var re = /^[0-9]+$/;
		if(re.test(value)){
		  return;
		}
	    return !value ? undefined : formatedMsg;
	}
});

