(function($, Onion) {
	Onion.config = {
		dialogStyle : 'tab', // tab, pop
		layer : {
			type : 2,
			area : [ '100%', '100%' ],
			title : '新页面',
			maxmin : true,
			shade : 0.1,
			anim: 1
		},
		url: {
			tree: '/component/tree',
			organ: '/sysOrganization/queryList'
		}
	}
	/**
	 * 打开一个地址 {id : id, href : href, title : title}
	 * 
	 * @param {Object} 地址
	 * @param {Boolean} 是否使用createAddress()方法创建链接
	 */
	Onion.open = function(address) {
		var self = this, style = address.style ? address.style : self.config.dialogStyle, urlConfig;
		if(address && address.description) {
			urlConfig = self.createAddress(address.url, address.description, address.title);
		} 
		if(address.style === 'pop'){
			urlConfig = address;
		} else if(address.style === 'dialog'){
			urlConfig = $.extend({area: [ '80%', '80%' ]}, address);
		}
		if (style === 'tab' && top.topManager && top.topManager.openPage && typeof top.topManager.openPage === 'function') {
			if(!urlConfig) {
				urlConfig = $.extend(urlConfig, address);
			}
			urlConfig.href = urlConfig.url;
			top.topManager.openPage(urlConfig);
		} else {
			urlConfig.content = urlConfig.url;
			urlConfig = $.extend(self.config.layer, urlConfig);
			urlConfig.success = function(layero, index){
			    var cw = layero.find('iframe')[0].contentWindow;
			    cw.$('.panel-header').hide();
			}
			layer.open(urlConfig);
		}
	};
	Onion.dialog = function(config) {
		var self = this;
		config.success = function(layero, index){
			try{
				var cw = layero.find('iframe')[0].contentWindow;
				cw.$('.panel-header').hide();
			}catch(e){}
		}
		if(config.url){
			config.content = config.url;
		}
		config = $.extend(self.config.layer, {area : [ '60%', '75%' ]}, config);
		layer.open(config);
	};
	Onion.close = function(obj) {
		var self = this, style = self.config.dialogStyle;
		if (style == 'tab' && top.topManager && top.topManager.openPage && typeof top.topManager.openPage === 'function') {
			top.topManager.closeRefresh();
		} else {
			var index = parent.layer.getFrameIndex(window.name);
			try{
				var grid = parent.BUI.Component.Manager.getComponent('grid1');
				grid.get('store').load();
			}catch(e){
				parent.location.reload();
			}
			parent.layer.close(index);
		}
	};
	Onion.createAddress = function(url, description, title) {
		var urlArr = url.split('/');
		var methodParam = urlArr[3] ? urlArr[3].split('?') : urlArr[2].split('?');
		var method = methodParam[0], param = methodParam[1], dialogId, recordId;
		dialogId = urlArr[2] + '-' + method;
		if(param){
			recordId = getQueryString('id', url);
			if(recordId) {
				dialogId += '-' + recordId;
			}
		}
		
		if(!title){
			if(method.indexOf('add') > -1) {
				title = '添加' + description;
			} else if(method.indexOf('edit') > -1) {
				title = '编辑' + description;
			} else if(method.indexOf('detail') > -1) {
				title = description + '详情[id=' + recordId + ']';
			}
		}
		return {id: dialogId, url: url, title: title};
	}

})(jQuery, window.ONION = window.ONION || {});


function parseQueryString(url) {
	var reg_url = /^[^\?]+\?([\w\W]+)$/,
		reg_para = /([^&=]+)=([\w\W]*?)(&|$|#)/g,
		arr_url = reg_url.exec(url),
		ret = {};
	if (arr_url && arr_url[1]) {
		var str_para = arr_url[1], result;
		while ((result = reg_para.exec(str_para)) != null) {
			ret[result[1]] = result[2];
		}
	}
	return ret;
}

//获取URL地址参数
function getQueryString(name, url) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
    if (!url || url == ""){
	    url = window.location.search;
    }else{	
    	url = url.substring(url.indexOf("?"));
    }
    r = url.substr(1).match(reg)
    if (r != null) return unescape(r[2]); return null;
}

/*$(function(){
	var leftContainer = $('.main-left .container');
	if(leftContainer){
		var height = $(window).outerHeight() - 60;
		leftContainer.css('min-height', height);
	}
});*/

;(function($, Onion){
	var URL = Onion.config.url;
	var SelectTree = {
		_init: function(el, opts){
			var self = this; 
			self.el = el;
			self.$el = $(el);
			self.$el.attr('readonly', 'readonly');
			var	hideId = self.$el.data('hideId'), hideIdEl = $('input[name=' + hideId + ']'), 
				hideParentIds = self.$el.data('hideParentIds'), hideParentIdsEl = $('input[name=' + hideParentIds + ']');
			self.$hideParentIdsEl = hideParentIdsEl;
			self.$hideIdEl = hideIdEl;
			self.opts = $.extend({}, $.fn.selectTree.opts, opts);
			self.url = (top.contextPath || '/only') + URL.tree + '?url=' + URL.organ + '&selectIds=' + hideIdEl.val();
			self._createDom();
		},
		_createDom: function(){
			var self = this;
			if(self.$el.next('button').hasClass('treeBtn')){
				self.$el.nextAll('button.treeBtn').remove();
				//return;
			}
			var btn = $('<button type="button" class="button treeBtn"><i class="icon-search"></i> </button>');
			self.$btn = btn;
			self.$el.after(btn);
			if(self.opts.style == 'popup') {
				self._renderPopup();
			} else if(self.opts.style == 'select'){
				self._renderSelect();
			}
		},
		_renderPopup: function(){
			var self = this;
			self.$btn.on('click', function(e){
				layer.open({type: 2, area: ['360px', '480px'], title: '请选择', content: top.contextPath + URL.tree + '?url=' + URL.organ,
					btn: ['确定', '取消'],
					yes: function(i, l){
						var tree = l.find("iframe")[0].contentWindow.tree;
						var data = getTreeData(tree);
						fillData.call(self, data);
						layer.closeAll();
				  	},
					btn2: function(){
				    	layer.closeAll();
					}
				});
			});
		},
		_renderSelect: function(){
			var self = this, $iframe = $('<iframe src="' + self.url + '" class="hide" style="z-index:9999;position:absolute;width:240px;height:420px;">'),
				parentHideBtn = self.$el.attr('name') + 'Btn', $hideBtn = $('<button type="button" class="button hide treeBtn" name="' + parentHideBtn + '"></button>');
			var offset = self.$el.offset();
			$('body').append($iframe);
			self.$btn.after($hideBtn);
			$iframe.load(function(e){
				var w = e.currentTarget.contentWindow;
				w.$('#tree').css({background: '#f5f5f5', border: '1px solid #ddd', padding: '5px'});
				w.$('body').attr('name', parentHideBtn);
				w.$('#ztree-btn-group').hide();
			})
			$iframe.css({left:offset.left + "px", top:offset.top + self.$el.outerHeight() + "px"})
			self.$btn.on('click', function(e){
				if($iframe.hasClass('hide')) $iframe.removeClass('hide');
				else $iframe.addClass('hide');
			});
			$hideBtn.on('click', function(e){
				var tree = $iframe[0].contentWindow.tree;
				var data = getTreeData(tree);
				fillData.call(self, data);
				$iframe.addClass('hide');
			});
		}
	}
	
	function getTreeData(tree){
		var nodes = tree.getSelectedNodes(), ids = [], names = [], parentIds = [];
		for(var i=0; i<nodes.length; i++) {
			ids.push(nodes[i].id);
			if(nodes[i].parentIds) parentIds.push(nodes[i].parentIds);
			names.push(nodes[i].name);
		}
		return {ids: ids, names: names, parentIds: parentIds};
	}
	
	function fillData(data){
		var self = this, ids = data.ids, names = data.names, parentIds = data.parentIds;
		self.$hideIdEl.val(ids.join(','));
		self.$el.val(names.join(','));
		if(self.$hideParentIdsEl && self.$hideParentIdsEl.length > 0) {
			if(ids && ids.length == 1 && parentIds && parentIds.length == 1) {
				self.$hideParentIdsEl.val(parentIds[0] + ids[0] + ',');
			}
		}
	}
	
	$.fn.selectTree = function(opts){
		return this.each(function(){
			var selectTree = Object.create(SelectTree);
			selectTree._init(this, opts)
		});
	};
	$.fn.selectTree.opts = {
		style: 'popup' // popup, select
	};
})(jQuery, ONION);
$(function(){
	$('.treeSelect').selectTree({style:'popup'});
});