define("bui/common/treesearch", ["bui/common","bui/grid","bui/data","bui/form",'bui/extensions/treegrid'], function(require, exports, module){
var BUI = require("bui/common"), 
	Grid = require("bui/grid"), 
	Data = require("bui/data"), 
	Form = require("bui/form"),
	TreeGrid = require("bui/extensions/treegrid");
/**
 * @class TreeSearch 搜索页类
 */
function TreeSearch(config) {
	TreeSearch.superclass.constructor.call(this, config);
    this._init();
}

TreeSearch.ATTRS = {
	/**
     * 是否tree-grid
     *
     * @type {Boolean}
     */
    isTreeGrid: {
        value: false
    },
    /**
     * 是否自动查询，打开页面时未点击查询按钮时是否自动查询
     *
     * @type {Boolean}
     */
    autoSearch: {
        value: true
    },
    /**
     * grid 容器的 id
     *
     * @type {String}
     */
    gridId: {
        value: 'grid'
    },
    /**
     * 表单的容器的id
     *
     * @type {String}
     */
    formId: {
        value: 'searchForm'
    },
    /**
     * 查询按钮的id
     *
     * @type {Object}
     */
    btnId: {
        value: 'btnSearch'
    },
    /**
     * 是否有充值按钮
     * 
     * @type {Boolean}
     */
    hasResetBtn: {
        value: false
    },
    /**
     * 重置按钮的id
     *
     * @type {Object}
     */
    btnResetId: {
        value: 'btnReset'
    },
    /**
     * 更多查询按钮的id
     *
     * @type {Object}
     */
    btnMoreId: {
        value: 'btnMore'
    },
    /**
     * 表单的配置项
     *
     * @type {Object}
     */
    formCfg: {
        value: {}
    },
    /**
     * 表单的配置项
     *
     * @type {Object}
     */
    storeCfg: {
        value: {}
    },
    /**
     * grid 表格的配置项
     *
     * @type {Object}
     */
    gridCfg: {},
    /**
     * 表单对象
     *
     * @type {Object}
     */
    form: {},
    /**
     * 表格对象
     *
     * @type {Object}
     */
    grid: {},
    /**
     * 数据缓冲类
     *
     * @type {Object}
     */
    store: {},
    /**
     * 分页的页码
     *
     * @type {Object}
     */
    pageList: {
    	value: [10, 15, 20, 30, 50, 100]
    },
}

BUI.extend(TreeSearch, BUI.Base);

BUI.augment(TreeSearch, {
    _init: function () {
        var _self = this;
        _self._initForm();
        _self._initStore();
        _self._initStoreEvent();
        _self._initGrid();
        _self._initOther();
        _self._initEvent();
        _self._initData();
    },
    // 初始化事件
    _initEvent: function () {
        this._initDomEvent();
        this._initFormEvent();
        this._initGridEvent();
    }, _initDomEvent: function () {
        var _self = this, btnId = _self.get('btnId'), store = _self.get('store'), form = _self.get('form');
        $('#' + btnId).on('click', function (ev) {
            ev.preventDefault();
            form.valid();
            if (form.isValid()) {
            	if(form.fire('beforesubmit') === false){
            		return ;
            	};
                _self.load(true);
            }
        });
        try{
        	var autoSearch = _self.get('autoSearch');
        	if(!autoSearch){
        		setTimeout(function(){
            		layer.tips('Hi，亲，点击我才去加载数据哦', '#' + btnId, {tips: [3, '#c00'], tipsMore: true});
            	}, 1000);
        	}
        }catch(e){}
    },
    // 初始化form
    _initForm: function () {
        var _self = this, form = _self.get('form');
        if (!form) {
            var formCfg = BUI.merge(_self.get('formCfg'), {
                srcNode: '#' + _self.get('formId')
            });
            form = new Form.HForm(formCfg);
            form.render();
            _self.set('form', form);
        };
    }, _initFormEvent: function () {
    	var _self = this, form = _self.get('form');
    },
    // 初始化Store
    _initStore: function() {
    	var _self = this, store = _self.get('store');
    	if(!store){
    		var storeCfg = _self.get('storeCfg'), isTreeGrid = _self.get('isTreeGrid');
    		if(isTreeGrid){
    			storeCfg = BUI.merge({
    				pidField: 'parentId', map: {name: 'text', id: 'id', children: 'children'}
	    	    }, storeCfg);
    			store = new Data.TreeStore(storeCfg);
            } else {
            	storeCfg = BUI.merge({
            		autoLoad: false, root: 'result', totalProperty: 'totalCount', remoteSort: true, proxy: {
                        method: 'post', dataType: 'json'
                    }, pageSize: 10, sortDirection: 'DESC', sortField: 'id'
	    	    }, storeCfg);
            	store = new Data.Store(storeCfg);
            }
    		_self.set('store', store);
    	}
    },
    // 初始化表格
    _initGrid: function () {
        var _self = this, grid = _self.get('grid');
        if (!grid) {
            var gridCfg = _self.get('gridCfg'), store = _self.get('store'), selector = '#' + _self.get('gridId'), isTreeGrid = _self.get('isTreeGrid');
            gridCfg.store = store;
            gridCfg.render = selector;
            gridCfg = BUI.merge({
            	width: BUI.gridWidth(selector)
        	}, gridCfg);
            if(isTreeGrid){
            	gridCfg = BUI.merge({
                	width: BUI.gridWidth(selector),
                	plugins: [Grid.Plugins.AutoFit, /*Grid.Plugins.RowNumber, */Grid.Plugins.ColumnResize]
            	}, gridCfg);
            	grid = new TreeGrid(gridCfg);
            } else {
            	gridCfg = BUI.merge({
            		root: 'result', totalProperty: 'totalCount', sortDirection: 'DESC', sortField: 'id', bbar: {pagingBar: true},
            		plugins: [Grid.Plugins.CheckSelection, Grid.Plugins.AutoFit, /*Grid.Plugins.RowNumber, */Grid.Plugins.ColumnResize]
            	}, gridCfg);
            	grid = new Grid.Grid(gridCfg);
            }
            grid.render();
            _self.set('grid', grid);
        }
    }, _initGridEvent: function () {
    	var _self = this, grid = _self.get('grid'), isTreeGrid = _self.get('isTreeGrid');
    	if(isTreeGrid){
    		grid.on('expanded', function(ev){
    			var node = ev.node;
    			if(node.children.length == 0){
    				node.leaf = true;
    			}
    		});
    	}
    },
    _initOther: function() {
    	// 创建reset more按钮 绑定操作
        var _self = this, btnId = _self.get('btnId'), hasResetBtn = _self.get('hasResetBtn'), btnResetId = _self.get('btnResetId'), btnMoreId = _self.get('btnMoreId'), 
        	formId = _self.get('formId'), $form = $('#' + formId), $btnMorePreEl;
        if(hasResetBtn){
        	$btnResetEl = $('<button type="button" id="' + btnResetId + '" class="button button-primary"><i class="fa fa-reply"></i> 重置</button>');
        	$('#' + btnId).after($btnResetEl);
        	$btnResetEl.on('click', function (ev) {
        		$form.get(0).reset();
        	});
        	$btnMorePreEl = $btnResetEl;
        } else {
        	$btnMorePreEl = $('#' + btnId);
        }
        var hideHeigh = $('.search-more', $form).outerHeight();
        if(hideHeigh > 10) {
        	var $btnMoreEl = $('<button type="button" id="' + btnMoreId + '" class="button button-primary"><i class="fa fa-angle-double-down"></i> 更多</button>');
        	$btnMorePreEl.after($btnMoreEl);
        	$btnMoreEl.on('click', function (ev) {
            	$("i", this).toggleClass("fa-angle-double-down fa-angle-double-up");
        		$('.search-more', $form).slideToggle("fast");
            });
        };
        // 创建bbar的选择页码
        var grid = _self.get('grid'), bbar = grid.get('bbar'), pageList = _self.get('pageList');
        if(bbar && pageList){
        	var content = '', store = _self.get('store'), pageSize = store.get('pageSize'),
        		pageId = BUI.guid('pageIndexSelect');
        	BUI.each(pageList, function(item){
        		content += '<option ' + (Number(item) == pageSize ? 'selected="selected"' : '') + '>' + item + '</option>'
        	});
        	content = '<ul style="margin:3px 10px;">每页<select id="' + pageId + '">' + content + '</select>条</ul>'
        	var	select = {xclass : 'bar',elCls : 'bbar-select pull-left',children : [{content : content}]};
          	bbar.addChild(select);
          	$('#' + pageId).on('change', function(e){
          		store.set('pageSize', this.value);
          		bbar.getChildAt(0).set('pageSize', Number(this.value));
          		store.load(true);
          	});
        }
        // 修复grid宽度
        // BUI.Grid.Format.fixWidth(grid);
    },
    _initData: function () {
        var _self = this, autoSearch = _self.get('autoSearch');
        if (autoSearch) {
            _self.load(true, true);
        }
    },
    // 初始化数据加载事件
    _initStoreEvent: function () {
        var _self = this, store = _self.get('store'), pidField = store.get('pidField'), isTreeGrid = _self.get('isTreeGrid');
        // 处理异常
        store.on('exception', function (ev) {
        	//BUI.Message.Alert(ev.error);
        	try{
        		console.log(ev.error);
        		BUI.Message.Alert('错误：' + ev.error);
        	}catch(e){
        		console.log(e)
        	}
        });
        store.on('beforeload', function(ev){
        	var params = ev.params;
        	params.sortField = params.field;
        	params.sortDirection = params.direction;
        	params.pageSize = params.limit;
        	if (isTreeGrid && params.id == params[pidField]) {
        		params._notQueryId = true;
        	}
        });
        store.on('beforeprocessload', function(ev){
        	//console.log(ev)
        });
        store.on('load', function(ev){
			var result = ev.target.getResult();
			if(isTreeGrid){
				setLeaf(result);
			}
		});
        
        function setLeaf(result){
        	$.each(result, function(i, item){
				if(item.hasOwnProperty('leaf')){
					item.leaf = false;
					if(item.children && item.children.length > 0){
						setLeaf(item.children);
					}
				}
			});
        }
    },
    /**
     * 加载数据
     *
     * @param {Boolean}
     *            reset 是否重置表格查询的页数
     * @param {Boolean}
     *            sendPid 是否发送默认TreeGrid查询的参数pidField=0   
     */
    load: function (reset, sendPid) {
        var _self = this, form = _self.get('form'), store = _self.get('store'), param = form.serializeToObject();
        var pidField = store.get('pidField'), isTreeGrid = _self.get('isTreeGrid');
    	if (sendPid) {
    		param[pidField] = 0;
    	}
    	/*if (isTreeGrid && (!param.hasOwnProperty(pidField) || !param[pidField])) {
    		var sum = 0, emptyCount = 0;
    		$.each(param, function(i, item){
    			sum++;
    			if(!item) emptyCount++;
    		});
    		if(sum == emptyCount) param[pidField] = 0;
        }*/
        if (reset) {
            param.start = 0;
            param.pageIndex = 0;
        }
        store.load(param);
    }
});

TreeSearch.createStoreCfg = function (url, cfg) {
    if (!url) {
        url = 'query';
    }
    cfg = BUI.merge({ 
    	autoLoad: false, url: url, remoteSort: true, proxy: { method: 'post', dataType: 'json' }
    }, cfg);
    return cfg;
};
TreeSearch.createGridCfg = function (columns, cfg) {
    cfg = BUI.merge({
        columns: columns, loadMask: true, forceFit: true,
        emptyDataTpl: '<div class="centered container no-data"><h3><span class="x-icon x-icon-warning x-icon-small">!</span>未查询到指定的数据！</h3></div>'
    }, cfg);
    return cfg;
};
TreeSearch.createLink = function (cfg) {
    var temp = '<span class="page-action grid-command" data-id="{id}" data-href="{href}" title="{title}">{text}</span>';
    return BUI.substitute(temp, cfg);
}
TreeSearch.cascadeExpandIframe = function(ev) {
	var data = ev.record, row = ev.row;
	$(row).find('iframe').load(function(ev){
		var win = ev.currentTarget.contentWindow, context = win.$('.panel'), grid1 = win.BUI.getControl('tree-grid1');
		if(!grid1) grid1 = win.BUI.getControl('grid1');
		context.css({border: 'none', 'padding-bottom': '0', 'margin-bottom': '0'})
		context.find('.panel-header').hide();
		context.find('form').hide();
		context.find('.bui-grid-tbar').hide();
		//var index = grid1.get('columns').length - 1;
		//grid1.findColumn(index).hide();
		grid1.removeColumn();
	});
}
TreeSearch.util = {
	add: function() {
		
	},
	edit: function(baseUrl, baseDescription, record, method, params) {
		var url = baseUrl + method + '.do?id=' + record.id + (params ? params : '');
		ONION.open({url: url, description: baseDescription});
	},
	ajaxEdit: function(saveData, url, search) {
		var _self = this;
		if(saveData && url) {
			var postData = JSON.stringify(saveData);
			$.ajax({
	            type : 'POST',
	            dataType:"json", 
	            contentType:"application/json", 
	            url : url,
	            data: postData,
	            success : _self.successCallback(search)
	        });
		}
	},
	ajax: function(postData, url, search) {
		var _self = this;
		if(postData && url) {
			$.ajax({
	            type : 'POST',
	            dataType:"json", 
	            url : url,
	            data: postData,
	            success : _self.successCallback(search)
	        });
		}
	},
	remove: function(ids, baseUrl, search) {
		var _self = this;
		if (ids && ids.length && baseUrl) {
			layer.confirm('确认要删除选中的记录么？', function() {
				$.ajax({url : baseUrl + 'remove.do', dataType : 'json', type : 'post', data : {ids : ids}, success : _self.successCallback(search)});
			});
		}
	},
	successCallback: function(search) {
		return function(result){
			if (result.success) {	
				search.load();
				layer.msg(result.msg, {icon: 6});
			} else {
				layer.msg(result.msg, {icon: 5});
			}
		}
	},
	getDialogGrid: function(iframe){
		if(iframe) {
			var iframeWin = iframe.contentWindow ? iframe.contentWindow : iframe;
			var grid = iframeWin.BUI.getControl('grid1');
			return grid;
		}
    }
};
module.exports = TreeSearch;
});
