define('bui/common/wdmenu',['bui/common'],function(require, exports, module) {
	
var BUI = require("bui/common");
function WDMenu(config) {
}

/**
 * 树形结构数据转换
 * 将wd portal等树形结构数据转换成BUI的树形结构
 */
WDMenu.Convert = {
		/**
		 * 转换成菜单
		 * {id: '1', name: 'hello', url: 'hello/hello', icon: 'fa fa-out', children:[]}
		 * @param {Object} sso TreeNode信息
		 * @param {Object} cfg 配置对象，id, pId等映射
		 * @return {Object} BUI的树形结构数据
		 */
		toMenu: function(menuVO, cfg){
			if(!menuVO){ return {};}
			var getId = (function(){
				var i = 1;
				return function(){
					return i++;
				};
			})();
			var cfg = BUI.merge({
					id : 'id', pId : 'parentId', children: 'children', rootId: 0, name: 'name', url: 'url', icon: 'icon', excludeIcon: false
				}, cfg);
			var menu = {id: getId(), name: menuVO[cfg.name], icon: menuVO[cfg.icon], url: menuVO[cfg.url]};
			var children = getChildren(menuVO);
			menu.children = children;
			function getChildren(menuVO){
				if(menuVO[cfg.children]){
					var children = [];
					$.each(menuVO[cfg.children], function(i, item){
						if (cfg.excludeIcon && item[cfg.icon]) {
							return true;
						} 
						var tempMenu = {id: getId() + '', name: item[cfg.name], icon: item[cfg.icon], url: item[cfg.url]};
						var tempChildren = getChildren(item);
						tempMenu.children = tempChildren;
						children.push(tempMenu);
					});
					return children;
				}
			}
			
			var icons = ['fa fa-tag', 'fa fa-cubes', 'fa fa-flag', 'fa fa-bullhorn','fa fa-flash', 'fa fa-heart', 'fa fa-book', 'fa fa-desktop'], 
				iconsLength = icons.length;
			$.each(menu.children, function(i, item){
				if(!item.icon){
					var index = i < iconsLength ? i : i % iconsLength;
					item.icon = icons[index];
				}
			});
			return menu;
		}
}

module.exports = WDMenu;	
});