/**
 * 将字典信息与数据统计信息合并
 * 作为磁条显示
 * @param $
 */
(function($){
	var Dashbord = {
		_init: function(elem, options){
			var self = this;
			self.options = $.extend({},$.fn.dashbord.options, options);
			self.elem = elem;
			self.$elem = $(elem);
			self._initData();
			self._display();
			self._addEvent();
		},
		_initData: function(){
			var self = this, $elem = self.$elem, options = self.options, icons = options.icons,
				targets = [], allObj = {value: '', text: '全部', cls: '', icon: icons[0]}, totalCount = 0;
			$elem.empty();
			$.each(options.dict, function(i, item){
				var cls = '';
				if(item.css) {
					var clsArr = item.css.split(' ');
					if(clsArr[1]) {
						cls = clsArr[1];
					} else {
						cls = clsArr[0];
					}
				}
				var index = (i + 1) % 4, count = 0, obj = {value: item.value, text: item.label, cls: cls, icon: icons[index]};
				$.each(options.data, function(i, statis){
					if(statis[options.dataKey] == item.value) {
						count = statis[options.dataCountKey];
						totalCount += count;
						return false;
					}
				});
				obj.count = count;
				targets.push(obj);
			});
			allObj.count = totalCount;
			targets.unshift(allObj);
			self.store = targets;
		},
		_display: function(){
			var self = this, $elem = self.$elem, options = self.options, store = self.store, html = '',
				width = 100 / store.length,
				tpl = '<ul style="width:' + width + '%;"><li data-' + options.dataKey + '="{value}" class="{cls}">{text}<span>{count}</span><i class="{icon}"> </i></li></ul>';
			$.each(store, function(i, item){
				var str = BUI.substitute(tpl, item);
				html += str;
			});
			$elem.html(html);
			/* <ul><li data-status=" " class="" >全部<span>18</span><i class="fa fa-comments"></i></li></ul> */
		},
		_addEvent: function(){
			var self = this;
			if(typeof self.options.onClick==="function" && self.options.onClick) {
				self.$elem.on('click', {store: self.store}, self.options.onClick);
			}
		}
	}
	$.fn.dashbord = function(options){
		return this.each(function(){
			var dashboard = Object.create(Dashbord);
			dashboard._init(this, options);
		});
	}
	$.fn.dashbord.options = {
		dict: null,
		data: null,
		dataKey: 'status',
		dataCountKey: 'count',
		icons: ['fa fa-comments', 'fa fa-bell', 'fa fa-plane', 'fa fa-car'],
		onClick: null
	}
})(jQuery);