
/**
 * 自定义折叠布局
 * 基于BUI样式 pannel
 * @param $
 */
(function($){
	var MyAccordion = {
			init:function(elem, options) {
				var self = this;
				self.options = $.extend({}, $.fn.myaccordion.options, options);
				self.elem = elem;
				self.$elem = $(elem);
				self.display();
				self.addEvent();
			},
			display:function() {
				var self = this, elStyle = self.options.elStyle, elCls = self.options.elCls,
					icon = $('<i class="fa fa-chevron-down fa-chevron-up toggle"></i>'), container = $('<div class="pull-right"></div>'),
					header = self.$elem.find('div.panel-header'), body = self.$elem.find('div.panel-body'),
					href = header.data('href'), hrefStr, 
					fold = body.data('fold') == undefined ? true : body.data('fold'),
					frameSrc = body.data('src');
				if(!header.hasClass('clearfix')){
					header.addClass('clearfix');
				}
				if(href) {
					hrefStr = '<h3 class="pull-left"><a id="' + href + '" name="' + href + '">' + header.html() + '</a></h3>';
				} else {
					hrefStr = '<h3 class="pull-left">' + header.html() + '</h3>';
				}
				header.html(hrefStr);
				icon.appendTo(container);
				header.append(container);
				if(frameSrc){
					var frameStr = '<iframe src="" class="box-iframe ' + (elCls ? elCls : '') 
					+ '" style="' + (elStyle ? elStyle : '') + '"></iframe>',
					frame = $(frameStr);
					body.append(frame);
					if(fold) {
						body.css('display', 'none');
					} else {
						frame.attr('src', frameSrc);
					}
					self.$frame = $(frame);
				} else {
					if(fold && body.css('display') == 'block') {
						body.css('display', 'none');
					}
				}
				if(!fold) {
					icon.toggleClass('fa-chevron-down');
				}
				self.$icon = icon;
			},
			addEvent:function() {
				var self = this, icon = self.$icon, 
					header = self.$elem.find('div.panel-header'),
					body = self.$elem.find('div.panel-body'), frameSrc = body.data('src');
				header.on('click', function(ev){
					if(body.css('display') == 'none' && frameSrc){
						self.$frame.attr('src', frameSrc);
					}
					body.toggle('fast');
					icon.toggleClass('fa-chevron-down');
				});
				if(typeof self.options.onComplete==="function" && self.options.onComplete) {
					self.options.onComplete.call(self.elem, self, self.$elem);
				}
			}
	};
	
	$.fn.myaccordion = function(options){
		return this.each(function(){
			var mt = Object.create(MyAccordion);
			mt.init(this, options);
		});
	};
	$.fn.myaccordion.options = {
		elCls: null,
		elStyle: 'height:500px',
		onComplete: null
	};
})(jQuery);